/**************************************************************************
***************************************************************************

Countdown from 99 to 0 on a dual digit 7 segment display
by Amos 12/10/2010 (that's October 12th!) 


***************************************************************************
***************************************************************************/

#include "mbed.h"

DigitalOut myLeftPins[] = {p7, p8, p9, p10, p11, p12, p13};
DigitalOut myRightPins[] = {p14, p15, p16, p17, p18, p19, p20};

/*
Individual numerals
int zero[] = {0, 0, 0, 1, 0, 0, 0};
int one[] = {0, 1, 1, 1, 1, 1, 0};
int two[] = {1, 0, 0, 0, 0, 1, 0};
int three[] = {0, 1, 0, 0, 0, 1, 0};
int four[] = {0, 1, 1, 0, 1, 0, 0};
int five[] = {0, 1, 0, 0, 0, 0, 1};
int six[] = {0, 0, 0, 0, 0, 0, 1};
int seven[] = {0, 1, 1, 1, 0, 1, 0};
int eight[] = {0, 0, 0, 0, 0, 0, 0};
int nine[] = {0, 1, 0, 0, 0, 0, 0};
*/

//This is an array of arrays where the first index into the array
//locates the pin combination which displays that digit
//eg numb[1] returns the array containg the segments to display 1.
int numb[10][7] = {{0, 0, 0, 1, 0, 0, 0},
                {0, 1, 1, 1, 1, 1, 0}, 
                {1, 0, 0, 0, 0, 1, 0}, 
                {0, 1, 0, 0, 0, 1, 0}, 
                {0, 1, 1, 0, 1, 0, 0}, 
                {0, 1, 0, 0, 0, 0, 1}, 
                {0, 0, 0, 0, 0, 0, 1}, 
                {0, 1, 1, 1, 0, 1, 0}, 
                {0, 0, 0, 0, 0, 0, 0}, 
                {0, 1, 0, 0, 0, 0, 0}};

int main()
{
    while(1)
    {
        for(int i = 0; i < 7; i++)
        {
            //clear all pins
            myLeftPins[i] = 1;
            myRightPins[i] = 1;
        }        
        //Countdown loop
        for(int x = 99; x >= 0; x--)
        {
            //set the main counter
            for(int i = 0; i < 7; i++)
            {
                //Left digit displays the value of x/10 ie the tens column
                myLeftPins[i] = numb[x/10][i]; 
                //Right digit displays the value of x%10 ie the units column
                myRightPins[i] = numb[x%10][i];         
            }
            //1 second
            wait(1);
        }
    }
}


