#define LOGDELAY 291

#include "mbed.h"
#include "BufferedSerial.h"
#include "SDFileSystem.h"
#include "ble/BLE.h"
#include "ble/services/DeviceInformationService.h"
#include "nrf_soc.h" // for internal Thermo sensor
#include "nrf51_rtc.h"
#include "Dht22.h"
#include <string>

//Serial pc(USBTX, USBRX);


char DEVICE_NAME[] = "IAQ"; //enter device name
const static char datapath[] = "/sd/datalog.txt";
Ticker wakeUp;
char hpmbuffer[10];
bool triggered = true;

/*
// Sensen Pin Configuration
*/

SDFileSystem sd(p25, p28, p29, p23, "sd");//Create an SDFileSystem object mosi, miso, sclk
I2C i2c(p30 , p7); //sda, scl
DigitalOut adp(p21);
DigitalOut sample_led(p17); //yellow - sampling
DigitalOut status_led(p18); //red - status

     

/*
// Sensor Configuration
*/

//analog sensors
AnalogIn spec(p1);
AnalogIn figCO(p2);
AnalogIn sharpVOut(p3);

//digital sensors
BufferedSerial hpm(p9,p11); //tx, rx
//SoftwareSerial plantower(p10, p12);
DigitalOut sharpLED(p13); //low = on
DigitalOut plantowerReset(p10);
DigitalOut plantowerSet(p12);
Dht22 dht(p14);
const int figCO2 = 0x69 << 1; // 8bit I2C address, 0x69 for figaro CO2
const int DS1307 = 0x68 << 1;


/*
// Global variables for data
*/
char rtcbuff[8];
float dataBuffer[30];
uint32_t timeNow = 0;
uint32_t wakeTime = 0;
float sharpPM = 0.0;
float specCO = 0.0;
float figaroCO = 0.0;
int dhtTemp = 0;
int dhtHum = 0;
int figaroCO2 = 0;
int honeywellPM2_5 = 0;
int honeywellPM10 = 0;
int plantowerPM1 = 0;
int plantowerPM2_5 = 0;
int plantowerPM10 = 0;
int32_t p_temp = 0;
float temperature = 0;

/*
// I2C functions
*/

void writeReg(int addr8bit, char reg, char val)
{
    char tempData[2];
    tempData[0] = reg;
    tempData[1] = val;
    i2c.write(addr8bit, tempData, 2);
}

void readReg(int addr8bit, uint8_t reg)
{
    char tempData[2];
    tempData[0] = reg;
    i2c.write(addr8bit, &tempData[0], 1, true);
    i2c.read(addr8bit, &tempData[1], 1, false);
}

int twosComp( char bit_msb, char bit_lsb)
{
    int16_t myInt=0;
    myInt = (bit_msb << 8) | (bit_lsb & 0xff);
    return myInt;
}


/*
// Sensor interface functions
*/

void getDHT()
{
    dht.read();
    dhtTemp = dht.getCelsius();
    dhtHum = dht.getHumidity();
}

void getFigaroCO2()
{
    char readme_msb, readme_lsb;
    
    char reg = 0x03;
    i2c.write(figCO2, &reg, 1, true);
    i2c.read(figCO2, &readme_lsb, 1, false);
    
    reg = 0x04;
    i2c.write(figCO2, &reg, 1, true);
    i2c.read(figCO2, &readme_msb, 1, false);
    
    figaroCO2 = twosComp(readme_msb,readme_lsb);
}

void getSharpPM()
{
    sharpVOut.read();
    wait_ms(5);
    sharpLED = 0;
    wait_us(280);
    sharpPM = sharpVOut.read();
    wait_us(40);
    sharpLED = 1;
    wait_us(9680);
}

void getSpecCO()
{
    spec.read();
    wait_ms(5);
    specCO = 0.0;
    for(int i=0; i<128; i++)
    {
        specCO += spec.read();
        wait_ms(2);
    }
    specCO = specCO/128.0;    
}

void getFigaroCO()
{
    figCO.read();
    wait_ms(5);
    figaroCO = 0.0;
    //for(int i=0; i<128; i++)
    //{
        figaroCO = figCO.read();
    //    wait_ms(2);
    //}
    //figaroCO = figaroCO/128.0;    
}

void getHPM()
{
    for(int i=0; i<8; i++) {
        hpmbuffer[i]=1;
    }
    for(int i=0; i<100; i++) {
        if(hpm.getc()==0x42) {
            if(hpm.getc()==0x4d) {
                for(int i=0; i<8; i++) {
                    hpmbuffer[i]=hpm.getc();
                }
                honeywellPM2_5 = twosComp(hpmbuffer[4],hpmbuffer[5]);
                honeywellPM10 = twosComp(hpmbuffer[6],hpmbuffer[7]);
                break;
            }
        }
    }
}

void getTime()
{
        char readreg;
    
        char reg = 0x00;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[0] = readreg - 6 * (readreg >> 4);;
        
        reg = 0x01;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[1] = readreg - 6 * (readreg >> 4);;
        
        reg = 0x02;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[2] = readreg - 6 * (readreg >> 4);;
        
        reg = 0x03;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[3] = readreg - 6 * (readreg >> 4);;
        
        reg = 0x04;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[4] = readreg - 6 * (readreg >> 4);;
        
        reg = 0x05;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[5] = readreg - 6 * (readreg >> 4);;
        
        reg = 0x06;
        i2c.write(DS1307, &reg, 1, true);
        i2c.read(DS1307, &readreg, 1, false);
        rtcbuff[6] = readreg - 6 * (readreg >> 4);;
        
        struct tm t;
        
        t.tm_year = (int)rtcbuff[6]+100;
        t.tm_mon = (int)rtcbuff[5]-1;           // Month, 0 - jan
        t.tm_mday = (int)rtcbuff[4];          // Day of the month
        t.tm_hour = (int)rtcbuff[2];
        t.tm_min = (int)rtcbuff[1];
        t.tm_sec = (int)rtcbuff[0];
        t.tm_isdst = 0;        // Is DST on? 1 = yes, 0 = no, -1 = unknown
        timeNow = mktime(&t);
}


void getData()
{
    getSharpPM();
    wait(0.25);
    
    getSpecCO();
    wait(0.25);
    
    getFigaroCO();
    wait(0.25);
    
    getFigaroCO2();
    wait(0.25);

    getHPM();
    for(int i = 0; i<5; i++)
    {
        if (honeywellPM2_5 == 0 && honeywellPM10 == 0)
        {
            wait(0.25);
            getHPM();
        }
    }
    wait(0.25);
    
    getDHT();
    if (dhtTemp == 0) 
    {   
        wait(5);
        getDHT();
    }
    wait(0.25);
    
    
}

 





/*
// SD functions
*/

void sd_begin()
{
    DigitalOut mosi(p25); //out
    DigitalIn miso(p28); //in
    miso.mode(PullUp);
    DigitalOut sclk(p29); //out
    DigitalOut cs(p23,1); //out

    plantowerReset = 1;
    plantowerSet = 1;
    adp = 1; //turn on ADP194
    sharpLED = 1;
    status_led=1; //turn on status led - red
    wait(0.25);
}


void sd_sleep()
{
    wait(0.25);
    status_led=0; //turn off status led - red
    adp = 0; //turn off ADP194
    sharpLED = 0;
    //set all SPI as outputs pulled down
    DigitalOut mosi(p25,0);
    DigitalOut miso(p28,0);
    DigitalOut sclk(p29,0);
    DigitalOut cs(p23,0);
}

void sd_header_write()//Write header sd card
{
    sd.mount();//Mount the filesystem
    wait(0.25);//wait for stabilization

    FILE *fp = fopen(datapath, "a"); //will overwrite any existing datalog.txt file
    if (fp != NULL) {
        fprintf(fp,"Time,PM2_5,PM10,sharpPM,dhtTemp,dhtHum,specCO,figaroCO,figaroCO2\r\n");
        wait(0.25); //seconds
    }
    fclose(fp);
    sd.unmount();//Unmount the filesystem
}

void saveData() 
{
    sd.mount();//Mount the filesystem
    wait(0.25);//wait for stabilization

    FILE *fp = fopen(datapath, "a"); //will overwrite any existing datalog.txt file
    if (fp != NULL) {
        //fprintf(fp,"%d,%.4f\r\n",temperature);
        fprintf(fp,"%d,%d,%d,%.4f,%d,%d,%.4f,%.4f,%d\r\n",timeNow,honeywellPM2_5,honeywellPM10,sharpPM,dhtTemp,dhtHum,specCO,figaroCO,figaroCO2);
        wait(0.25); //seconds
    }
    fclose(fp);
    sd.unmount();//Unmount the filesystem

}

/*
// Clock functions
*/

void checkTime() 
{
    timeNow = rtc.time();
    if (timeNow > wakeTime) {
        triggered = true;
    }
    //timeNow = rtc.time();
    //wakeTime = timeNow + LOGDELAY;
}





int main(void)
{    
    /*
    //set time
    int val = 5;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x00,val);
    
    val = 5;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x01,val);
    
    val = 0;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x02,val);
    
    val = 20;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x03,val);
    
    val = 26;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x04,val);
    
    val = 10;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x05,val);
    
    val = 17;
    val = ( ( val / 10 ) * 0x10 ) + ( val % 10 );
    writeReg(DS1307,0x06,val);
    
    while(1)
    {
        sample_led = !sample_led;
        wait(1);
    }

    */
    
    //pc.printf("starting up... \n");
    /*
    sd_begin();
    while(1)
    {   
    
        
        while(1)
        {
            if(hpm.getc()==0x42)
            {
                if(hpm.getc()==0x4d)
                {
                    for(int i=0;i<8;i++)
                    {
                        hpmbuffer[i]=hpm.getc();
                    }
                    break;
                }
            }
        }

        FILE *fp = fopen(datapath, "a"); //will overwrite any existing datalog.txt file
        if (fp != NULL) {
            fprintf(fp,"%x,%x,%x,%x\r\n",hpmbuffer[4],hpmbuffer[5],hpmbuffer[6],hpmbuffer[7]);
            //fprintf(fp,"%d,%.4f,%.4f,%.4f,%.4f\r\n",timeNow,sharpPM,specCO,figaroCO,figaroCO2        
        }
        fclose(fp);
        */
        
/*
        char readme_msb, readme_lsb;
    
        char reg = 0x03;
        i2c.write(figCO2, &reg, 1, true);
        i2c.read(figCO2, &readme_lsb, 1, false);
        
        reg = 0x04;
        i2c.write(figCO2, &reg, 1, true);
        i2c.read(figCO2, &readme_msb, 1, false);
        
        int16_t xval = twosComp(readme_msb,readme_lsb);
        figaroCO2 = (float)xval/15987; 
        
        pc.printf("figaroCO2 %f\n", figaroCO2);
        wait(1);
    */
 
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init();
    sd_begin();
    sd_header_write();
    sample_led = 1;

    while (ble.hasInitialized()  == false) {
    }
    
    while(true) {  
        
        //wait(5);
        if(triggered)
        {
            sd_begin();
            wait(1);
/*        
        getTime();
        getDHT();
        pc.printf("%ld,%d,%d,%d,%d,%d,%d,%d,",timeNow,rtcbuff[0],rtcbuff[1],rtcbuff[2],rtcbuff[3],rtcbuff[4],rtcbuff[5],rtcbuff[6]);
        pc.printf("%d,%d\n\r",dhtTemp,dhtHum);
        wait(5);    
*/
        
        //getData();
        //specCO = spec.read();
        //sd_temp_get(&p_temp);
        //temperature = float(p_temp)/4.;
                
        //pc.printf("%.4f\n",specCO);
        
            getTime();
            wakeTime = timeNow + LOGDELAY;
            
            for(int i = 0; i < 2; i++) 
            {
                getTime();
                sample_led = 1;
                getData();
                sample_led = 0;
                saveData();
            }
            
            
            rtc.set_time(timeNow);
            triggered = false;
            sd_sleep(); //powers off everything
        }
        else 
        {        
            wakeUp.attach(&checkTime, 10); 
            ble.waitForEvent();
            __wfe();
            wakeUp.detach();
        }
    }
}