 #include "mbed.h"
 #include "Servo.h"
 #include "MMA8452.h"
 #include "PinDetect.h"

Serial pc(USBTX,USBRX);
DigitalOut myLed(LED1);
PinDetect pb1(p26);



DigitalOut Red4(p5);
DigitalOut Red3(p6);
DigitalOut Yel2(p7);
DigitalOut Grn1(p8);


Servo _base(p21);
Servo _shoulder(p22);
Servo _elbow(p23);
Servo _sword(p24);


void countdown(){
    Red4 = 1;
    wait(.75);
    Red4 = 0;
    Red3 = 1;
    wait(.75);
    Red3 = 0;
    Yel2 = 1;
    wait(.75);
    Red4 = 1;
    Red3 = 1;
    Grn1 = 1;
    wait(.75);
    Red4 = 0;
    Red3 = 0;
    Yel2 = 0;
    Grn1 = 0;
  }


void swing(){
    _sword.write(1.0);
    wait(.1);
    _sword.write(0.0);
  }

int main() {

   pb1.mode(PullUp);
   int timer = 0;
   //float _baseRead = 0, _shoulderRead = 0, _elbowRead = 0;
   double x = 0, y = 0, z = 0;
   MMA8452 acc(p28, p27, 40000);  //instantiate an acc object 
   
   //set parameters -- use these and don't change
   acc.setBitDepth(MMA8452::BIT_DEPTH_12);
   acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
   acc.setDataRate(MMA8452::RATE_100);
   countdown();
   
   while(1) {
    

      acc.readXYZGravity(&x,&y,&z); //notice this is passed by reference use pointers

      _base.write((-y+1)/2);
      _shoulder.write((-x+1)/2);
      //_elbow.write((x+1)/2);

      if(!pb1){
        myLed=1;
        swing();
        myLed=0;
    }
                          
      // You can uncomment this line to see the values coming off the MMA8452           
      //printf("(%.2f,%.2f,%.2f)", x,y,z);
      //printf("(%.5f,%.5f,%.5f)", _baseRead, _shoulderRead, _elbowRead);
      //printf("\n");
      
      timer++;      
      } //infinite while loop 
   } //end main