#include "mbed.h"
#include "airhumidity.h"
#include <string>

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
Serial bt(PTE22, PTE23); // initializing Uart1 channel for connecting the bluetooth device
AnalogIn gas_output(PTB1); //initializing the ADC output for gas sensor
 
using namespace std;
 
DigitalOut R1 (D6);
DigitalOut R2 (D7);
DigitalOut R3 (D8);
DigitalOut R4 (D9);
 
InterruptIn C1 (D10);
DigitalIn C2 (D11);
DigitalIn C3 (D12);
 
DigitalOut keyled(LED1);
DigitalOut flash(LED4);
 
AnalogIn ain(PTB0);
 
Timer t;
float tm ;
 
char key;
int s=0;

float value_adc =0.0f;
int dig_value = 0;
Timer timeout;
float current_time = 0.0;

unsigned char arrkey[12]={ '1' , '2' , '3' ,
                            '4' , '5' , '6' ,
                            '7' , '8' , '9' ,
                            '*' , '0' , '#' };
                            
char msg;
float temp=0.0;
float humid=0.0;
int unit =0;
string room_safety_status = "issafe";
bool room_safe = true;
bool someone_in = false;
bool door_lock_status = true;
string is_door_locked = "locked";
string room_status = "yes";
string room_gas_status = "safe";
float gas_sensor_value = 0.0;

bool allow_entrance = false;
bool authorized_person_entered = false;
bool authorized_person_left = true;
string last_person = "N/A";

                            
void unlock (){
    printf("DOOR UNLOCK: Welcome!\n\r");
    door_lock_status = false;
}
 
void lock (){
    printf("DOOR LOCK\n\r");
    door_lock_status = true;
} 
 
unsigned char char_string[4]= {'*' ,'*' ,'*' ,'*'};
unsigned char password[4]={'1' , '2' , '3' , '4'};
unsigned char passwordA[4]={'4' , '5' , '6' , '7'};

unsigned char keypad(){
    unsigned char r,b;
      
    while(current_time<5){
        current_time = timeout.read();
        for (r=0; r<4; r++){
            b=4;
            R1 = 1; R2 = 1 ; R3 = 1 ; R4 = 1;
            if (r == 0) R1 = 0;
            if (r == 1) R2 = 0;
            if (r == 2) R3 = 0;
            if (r == 3) R4 = 0;
              
            if(C1==0) b=0;
            if(C2==0) b=1;
            if(C3==0) b=2;
             
            if ((!(b==4))){
                key=arrkey[(r*3)+b];
                while(C1==0);
                while(C2==0);
                while(C3==0);
           
                wait(0.2);
            
                char_string[s] = key;
                s++;
                return key;
            }
          
        }
    }
    return 'Q';
}
 
void handleKeypad (){
    
    bool finished = false ; 
    printf("In Intruppt\n\r");
    __disable_irq();
    C1.disable_irq ();
 
    int firsttime = 0;

    if (firsttime == 0)
    {
        s = -1;
        timeout.reset();
        timeout.start();
    }
    
    current_time = timeout.read();
        
    while ((! finished) && (current_time < 5.0)){
            key = keypad();
            current_time = timeout.read();
            if (s == 4){
                finished = true;
                firsttime = 1;
                
                printf("Password: ");  
                for (int i = 0 ; i < 4 ; i++)
                    printf("%c", char_string[i]);
                    printf("\n\r");
                s = 0; 
                /////////////check password functions//////////
                int j = 0;
                int matchSara = 1;
                while (j < 4){
                    if (char_string [j] == password[j])
                        j++;
                    else{
                        matchSara = 0;
                        break;
                        }
                    if(matchSara && j == 3)
                    {
                        last_person = "Sara";
                        allow_entrance = true; 
                        door_lock_status = false;   
                        room_safety_status = "issafe";
                        room_safe = true;
                    }       
                }
                
                int k = 0;
                int matchAmir = 1;
                while (k < 4){
                    if (char_string [k] == passwordA[k])
                        k++;
                    else{
                        matchAmir = 0;
                        break;
                        } 
                    if(matchAmir && k == 3)
                    {
                        last_person = "Amir";
                        allow_entrance = true;  
                        door_lock_status = false;  
                        room_safety_status = "issafe";
                        room_safe = true;
                    }          
                }
                
                if (matchSara == 1){
                    printf("MATCH Sara\n\r");
                    room_safety_status = "issafe";
                    room_safe = true;
                    unlock();
                    C1.enable_irq();
                    __enable_irq();
                    break;
                }
                else if (matchAmir == 1){
                    printf("MATCH Amir\n\r");
                    room_safety_status = "issafe";
                    room_safe = true;
                    unlock();
                    C1.enable_irq();
                    __enable_irq();
                    break;
                }
                else{
                    printf("WRONG\n\r");
                    printf("lock for wrong password\n\r");
                    C1.enable_irq();
                    __enable_irq();
                    break;
                }          
            } // end s=4
    } //end while                
    timeout.stop();    
    C1.enable_irq ();
    __enable_irq();
}


void uart_interrupt_fun() {
    __disable_irq();
    msg = bt.getc();
    //pc.putc(msg);
    if(msg == 's'){
        msg = 'n';
        wait(1);
        //pc.printf(" \n\r") ;
        bt.printf("info %4.2f %4.2f %s %s %s %s %s end\n\r", temp, humid, room_status,room_gas_status, room_safety_status, last_person, is_door_locked) ; 
        wait(3);
        for(int i=0; i<2; i++)
        {
            myled = 1;
            wait(0.2);
            myled = 0;
            wait(0.2);
        }
        
    }
    __enable_irq();
    
}

void check_rooms_presence_safety()
{
    if(someone_in)
    {
        if( !door_lock_status )
        {
            
            room_safety_status = "issafe";
            room_safe = true;
            authorized_person_entered = true;
            if(authorized_person_entered)
            {
                door_lock_status = true;    
            }
        }
        else /*if(!authorized_person_entered || authorized_person_left) */
        {
            room_safety_status = "notsafe"; 
            room_safe = false;   
        }
    }
    if(! someone_in)
    {
        if(authorized_person_entered)
        {
            authorized_person_left = true;
            authorized_person_entered = false;
            allow_entrance = false;
            door_lock_status = true;
            room_safety_status = "issafe"; 
            room_safe = true;
        }
        if(!authorized_person_entered && !(door_lock_status))
        {
            door_lock_status = false;   
        }
        if(!room_safe)
        {
            room_safety_status = "notsafe";    
        }
        
    }
    
}

const char * gas_status_function()
{
    if(gas_sensor_value < 45)
    {
        return  "safe";    
    }
    else
    {
        return "danger";    
    }
    return "notvalid";
}

void PIR_status_function()
{
    if (value_adc < 0.2)
    {
            //printf("Nobody is here!\n\r");
            someone_in = false;
    }
    else {
            //printf("Somebody is here!\n\r");
            someone_in = true;
    }
}


const char * change_room_status_string()
{
    if(someone_in)
    {
        return "yes";    
    }
    else
    {
        return "no";    
    }
}

const char * door_lock_status_func()
{
    if(door_lock_status)
    {
        return "lock";
    }
    else
    {
        return "unlock";
    }
}

void print_data_uart0()
{
    printf("Temperature is %4.2f C \r\n",temp);
    printf("Humid is %4.2f  \r\n",humid);
    printf("Presence: %s  \r\n",room_status);
    printf("gas: %f\r\n", gas_sensor_value);
    printf("room safety: %s\r\n",room_safety_status);
    printf("door lock status %s\n\r", is_door_locked); 
    printf("Analog %5.2f\n\r",value_adc);   
}


int main() {
        
    while(1){
        
        bt.baud(38400);
        bt.attach(&uart_interrupt_fun);
        
        R4 = 0;
        C1.fall(&handleKeypad);
        
        temp = get_air_temp_inside(unit);
        humid = get_air_humid_inside();
        value_adc = ain.read();
        gas_sensor_value = gas_output.read()*50;
        check_rooms_presence_safety();       
        room_gas_status = gas_status_function();
        PIR_status_function();
        room_status = change_room_status_string();
        is_door_locked = door_lock_status_func();
        print_data_uart0();        
    }
}
