#include "mbed.h"
#include "airhumidity.h"
#include <string>

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
Serial bt(PTE22, PTE23);
AnalogIn gas_output(PTB1);
 
 ///////////////////sara's code///////////////////
 
using namespace std;
 
DigitalOut R1 (D6);
DigitalOut R2 (D7);
DigitalOut R3 (D8);
DigitalOut R4 (D9);
 
InterruptIn C1 (D10);
DigitalIn C2 (D11);
DigitalIn C3 (D12);
 
DigitalOut keyled(LED1);
DigitalOut flash(LED4);
 
AnalogIn ain(PTB0);
 
Timer t;
float tm ;
 
char key;
int s=0;

float value_adc =0.0f;
int dig_value = 0;
Timer timeout;
float current_time = 0.0;



unsigned char arrkey[12]={ '1' , '2' , '3' ,
                            '4' , '5' , '6' ,
                            '7' , '8' , '9' ,
                            '*' , '0' , '#' };

///////////////sara's part//////////////

char msg;


float temp=0.0;
float humid=0.0;
int unit =0;
string room_safety_status = "issafe";
bool someone_in = false;
bool door_status = false;
string room_status = "yes";
string room_gas_status = "safe";
float gas_sensor_value = 0.0;

bool authorized_person_inside = false;
bool authorized_person_entered = false;
string last_person = " ";

                            
void unlock (){
    printf("DOOR UNLOCK: Welcome!\n\r");
    door_status = true;
}
 
void lock (){
    printf("DOOR LOCK\n\r");
} 
 
unsigned char char_string[4]= {'*' ,'*' ,'*' ,'*'};
unsigned char password[4]={'1' , '2' , '3' , '4'};
unsigned char passwordA[4]={'4' , '5' , '6' , '7'};

unsigned char keypad(){
    unsigned char r,b;
      
    while(current_time<5){
        current_time = timeout.read();
        for (r=0; r<4; r++){
            b=4;
            R1 = 1; R2 = 1 ; R3 = 1 ; R4 = 1;
            if (r == 0) R1 = 0;
            if (r == 1) R2 = 0;
            if (r == 2) R3 = 0;
            if (r == 3) R4 = 0;
              
            if(C1==0) b=0;
            if(C2==0) b=1;
            if(C3==0) b=2;
             
            if ((!(b==4))){
                key=arrkey[(r*3)+b];
                while(C1==0);
                while(C2==0);
                while(C3==0);
           
                wait(0.2);
            
                char_string[s] = key;
                s++;
                return key;
            }
          
        }
    }
    return 'Q';
}
 
void handleKeypad (){
    
    bool finished = false ; 
    printf("In Intruppt\n\r");
    __disable_irq();
    C1.disable_irq ();
 
    int firsttime = 0;

    if (firsttime == 0)
    {
        s = -1;
        timeout.reset();
        timeout.start();
    }
    
    current_time = timeout.read();
        
    while ((! finished) && (current_time < 5.0)){
            key = keypad();
            current_time = timeout.read();
            if (s == 4){
                finished = true;
                firsttime = 1;
                
                printf("Password: ");  
                for (int i = 0 ; i < 4 ; i++)
                    printf("%c", char_string[i]);
                    printf("\n\r");
                s = 0; 
                
                
                /////////////check password functions//////////
                int j = 0;
                int matchSara = 1;
                while (j < 4){
                    if (char_string [j] == password[j])
                        j++;
                    else{
                        matchSara = 0;
                        break;
                        }
                    if(matchSara && j == 3)
                    {
                        last_person = "Sara";
                        authorized_person_inside = true;    
                        room_safety_status = "issafe";
                    }       
                }
                
                int k = 0;
                int matchAmir = 1;
                while (k < 4){
                    if (char_string [k] == passwordA[k])
                        k++;
                    else{
                        matchAmir = 0;
                        break;
                        } 
                    if(matchAmir && k == 3)
                    {
                        last_person = "Amir";
                        authorized_person_inside = true;    
                        room_safety_status = "issafe";
                    }          
                }
                
                if (matchSara == 1){
                    printf("MATCH Sara\n\r");
                    unlock();
                    C1.enable_irq();
                    __enable_irq();
                    break;
                }
                else if (matchAmir == 1){
                    printf("MATCH Amir\n\r");
                    unlock();
                    C1.enable_irq();
                    __enable_irq();
                    break;
                }
                else{
                    printf("WRONG\n\r");
                    printf("lock for wrong password\n\r");
                    C1.enable_irq();
                    __enable_irq();
                    break;
                }
                /////////////check password functions//////////
            
            } // end s=4

    } //end while                
       
    
    timeout.stop();    
    C1.enable_irq ();
    __enable_irq();
}




void uart_interrupt_fun() {
    __disable_irq();
    msg = bt.getc();
    //pc.putc(msg);
    if(msg == 's'){
        msg = 'n';
        wait(1);
        //pc.printf(" \n\r") ;
        bt.printf("info %4.2f %4.2f %s %s %s %s end\n\r", temp, humid, room_status,room_gas_status, room_safety_status, last_person) ; 
        wait(3);
        for(int i=0; i<2; i++)
        {
            myled = 1;
            wait(0.2);
            myled = 0;
            wait(0.2);
        }
        
    }
    __enable_irq();
    
}

void check_rooms_presence_safety()
{
    if(someone_in)
    {
        if(authorized_person_inside)
        {
            room_safety_status = "issafe";
            authorized_person_entered = true;
        }
        else
        {
            room_safety_status = "notsafe";    
        }
    }
    if(! someone_in)
    {
        if(authorized_person_entered)
        {
            authorized_person_inside = false;
            room_safety_status = "notsafe"; 
        }
    }
    
}


int main() {
        
    
    while(1) {

        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);

        temp = get_air_temp_inside(unit);
        humid = get_air_humid_inside();
        
        ///////////////////sara's code////////////
        value_adc = ain.read();
        gas_sensor_value = gas_output.read()*50;
        check_rooms_presence_safety();
        
        
        if(gas_sensor_value < 45)
        {
            room_gas_status = "safe";    
        }
        else
        {
            room_gas_status = "danger";    
        }
        
        printf("Analog %5.2f\n\r",value_adc);  
       
        if (value_adc < 0.2){
            //printf("Nobody is here!\n\r");
            someone_in = false;
        }
        else {
            //printf("Somebody is here!\n\r");
            someone_in = true;
        }
        ////////////////////////
        
        
        
        bt.baud(38400);
        bt.attach(&uart_interrupt_fun);
        
        R4 = 0;
        C1.fall(&handleKeypad);
        
        
        
        wait(1);
        
        
        if(someone_in)
        {
            room_status = "yes";    
        }
        else
        {
            room_status = "no";    
        }
        
        printf("Temperature is %4.2f C \r\n",temp);
        printf("Humid is %4.2f  \r\n",humid);
        printf("Presence: %s  \r\n",room_status);
        printf("gas: %f\r\n", gas_sensor_value);
        printf("room safety: %s\r\n",room_safety_status);
            
    }
}
