#include "mbed.h"
#include "board.h"
#include "SerialDisplay.h"


AnalogIn Vbat(PA_4);
AnalogIn Led1(PA_1);
AnalogIn Led2(PC_0);
AnalogIn RM(PC_2);
AnalogIn Vce(PB_1);
DigitalOut Relay(D6);
AnalogIn Exit(PC_4);
//AnalogIn Exit2(PC_5);

/**
 * Main application entry point.
 */
Serial pc(SERIAL_TX, SERIAL_RX,115200);
int MY_SetSysClock_PLL_HSE(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;

    /* Enable HSE and activate PLL with HSE as source */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState       = RCC_HSE_ON; /* External 8 MHz xtal on OSC_IN/OSC_OUT */

    // PLLCLK = (8 MHz * 8)/2 = 32 MHz
    RCC_OscInitStruct.PLL.PLLState        = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource       = RCC_PLLSOURCE_HSE;
    RCC_OscInitStruct.PLL.PLLMUL          = RCC_PLLMUL_8;
    RCC_OscInitStruct.PLL.PLLDIV          = RCC_PLLDIV_2;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        return (-1); // FAIL
    }

    /* Select PLL as system clock source and configure the HCLK, PCLK1 and PCLK2 clocks dividers */
    RCC_ClkInitStruct.ClockType      = (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
    RCC_ClkInitStruct.SYSCLKSource   = RCC_SYSCLKSOURCE_PLLCLK; // 32 MHz
    RCC_ClkInitStruct.AHBCLKDivider  = RCC_SYSCLK_DIV1;         // 32 MHz
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;           // 32 MHz
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;           // 32 MHz
    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK) {
        return (-2); // FAIL
    }

    /* Enable HSE and activate PLL with HSE as source */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI48|RCC_OSCILLATORTYPE_HSI|RCC_OSCILLATORTYPE_MSI;
    RCC_OscInitStruct.HSIState       = RCC_HSI_OFF;
    RCC_OscInitStruct.MSIState       = RCC_MSI_OFF;
    RCC_OscInitStruct.HSI48State     = RCC_HSI48_OFF;
    RCC_OscInitStruct.PLL.PLLState   = RCC_PLL_NONE;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        return (-3); // FAIL
    }
        
    return 0; // OK
}

void my_patch(void)
{
    int retVal;
    
    // Put device into default clock, i.e using MSI = 2MHz
    HAL_RCC_DeInit();
    
    // Enable HSE clock
    retVal = MY_SetSysClock_PLL_HSE();
    if(retVal< 0)
    {
        // fail
        //pc.printf("Failed to start HSE, ERR= %d\r\n", retVal);
        
        // indicate error
        while(1)
        {

        }
    }    
}

int main()
{ 
    
    pc.printf("mbed-os-rev: %d.%d.%d   lib-rev: %d\r\n", \
            MBED_MAJOR_VERSION, MBED_MINOR_VERSION,MBED_PATCH_VERSION,MBED_LIBRARY_VERSION);
    pc.printf("BUILD= %s, SysClock= %d, RCC= %0X\r\n", __TIME__, SystemCoreClock, RCC->CR);   
    my_patch();
    pc.printf("NEW SysClock= %d, NEW RCC= %0X\r\n", SystemCoreClock, RCC->CR);
    wait(1);
    
    printf("\n");
    printf("\n");
    int min=0,count=0;
      
    float meas_Vbat,meas_Led1,meas_Led2,meas_RM,meas_Vce,meas_Exit,meas_Exit2;
    float v_Vbat,v_Led1,v_Led2,v_RM,v_Vce,v_Exit,v_Exit2;
 //   float meas_v;



   pc.printf("***Charging Mode***\n\n");
   Relay= 0; // Start the test Relay =1
 
//    printf("\tAnalogIn example\n");    
    printf("count");
    printf("\tVbat");
    printf("\tLED1");
    printf("\tLED2");
    printf("\tRM");     
    printf("\tVce");
    printf("\tExit");
  //  printf("\tExit2");
    printf("\n");


 for(int j=0;j<=300;j++){
      meas_Vbat = Vbat.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
      meas_Led1 = Led1.read() - Vce.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
      meas_Led2 = Led2.read() - Vce.read();
      meas_RM = RM.read() - Vce.read();  
      meas_Vce = Vce.read(); 
      meas_Exit = Exit.read();
   //   meas_Exit2 = Exit2.read();
      

      
      // Display readings
      v_Vbat = meas_Vbat * 3300 *2;
      v_Led1 = (meas_Led1 * 3.300)/2.2;
      v_Led2 = (meas_Led2 * 3.300)/2.2;
      v_RM = (meas_RM * 3.300)/2.2;  
      v_Vce = meas_Vce * 3.300; 
      v_Exit = meas_Exit * 3.300/24;
    //  v_Exit2 = meas_Exit2 * 3.300/2.2;
      

      printf("%d\t", count);
      printf("%.0f\t", v_Vbat);
      printf("%.03f\t", v_Led1);
      printf("%.03f\t", v_Led2);
      printf("%.03f\t", v_RM);
      printf("%.03f\t", v_Vce);
      printf("%.03f\t",v_Exit);
   //   printf("%.03f\t",v_Exit2);
      printf("\n");

      count++;
     wait(0.1); // 10 second

}
     count = 0;

  
   pc.printf("***Discharging Mode 1***\n\n");
   Relay= 0; // Start the test Relay =1
 
//    printf("\tAnalogIn example\n");    
    printf("count");
    printf("\tVbat");
    printf("\tLED1");
    printf("\tLED2");
    printf("\tRM");     
    printf("\tVce");
    printf("\tExit");
   // printf("\tExit2");
    printf("\n");


 for(int j=0;j<=300;j++){
      meas_Vbat = Vbat.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
      meas_Led1 = Led1.read() - Vce.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
      meas_Led2 = Led2.read() - Vce.read();
      meas_RM = RM.read() - Vce.read();  
      meas_Vce = Vce.read(); 
      meas_Exit = Exit.read();
   //   meas_Exit2 = Exit2.read();
      

      
       // Display readings
      v_Vbat = meas_Vbat * 3300 *2;
      v_Led1 = (meas_Led1 * 3.300)/2.2;
      v_Led2 = (meas_Led2 * 3.300)/2.2;
      v_RM = (meas_RM * 3.300)/2.2;  
      v_Vce = meas_Vce * 3.300; 
      v_Exit = meas_Exit * 3.300/24;
    //  v_Exit2 = meas_Exit2 * 3.300/2.2;
      

      printf("%d\t", count);
      printf("%.0f\t", v_Vbat);
      printf("%.03f\t", v_Led1);
      printf("%.03f\t", v_Led2);
      printf("%.03f\t", v_RM);
      printf("%.03f\t", v_Vce);
      printf("%.03f\t",v_Exit);
   //   printf("%.03f\t",v_Exit2);
      printf("\n");

      count++;
   wait(0.1); // 10 second
}




    printf("\n");
    printf("\n");
    pc.printf("***Discharging Mode 2***\n\n");
//    printf("\tAnalogIn example\n");    
    printf("min");
    printf("\tVbat");
    printf("\tLED1");
    printf("\tLED2");
    printf("\tRM");     
    printf("\tVce");
    printf("\tExit");
   // printf("\tExit2");
    printf("\n");

    while(1) {
      Relay= 0; // Start the test Relay =1
      
      meas_Vbat = Vbat.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
      meas_Led1 = Led1.read() - Vce.read(); // Read the analog input value (value from 0.0 to 1.0 = full ADC conversion range)
      meas_Led2 = Led2.read() - Vce.read();
      meas_RM = RM.read() - Vce.read();  
      meas_Vce = Vce.read(); 
      meas_Exit = Exit.read();
     // meas_Exit2 = Exit2.read();
      
      
    // Display readings
      v_Vbat = meas_Vbat * 3300 *2;
      v_Led1 = (meas_Led1 * 3.300)/2.2;
      v_Led2 = (meas_Led2 * 3.300)/2.2;
      v_RM = (meas_RM * 3.300)/2.2;  
      v_Vce = meas_Vce * 3.300; 
      v_Exit = meas_Exit * 3.300/24;
    //  v_Exit2 = meas_Exit2 * 3.300/2.2;
      

      printf("%d\t", min);
      printf("%.0f\t", v_Vbat);
      printf("%.03f\t", v_Led1);
      printf("%.03f\t", v_Led2);
      printf("%.03f\t", v_RM);
      printf("%.03f\t", v_Vce);
      printf("%.03f\t",v_Exit);
   //   printf("%.03f\t",v_Exit2);
      printf("\n");

     
    wait(5.0); // 10 second
      min++;
    }

}
