/* Copyright (c) <2018> <MultiTech Systems>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __MODEREGION_H__
#define __MODEREGION_H__

#include <string>
#include <vector>

#include "Mode.h"
#include "LayoutScrollSelect.h"

class ModeRegion : public Mode {
public:
    ModeRegion(DOGS102* lcd,
               ButtonHandler* buttons,
               mDot* dot,
               LoRaHandler* lora,
               GPSPARSER* gps,
               SensorHandler* sensors,
               const char* file_cp);
    ~ModeRegion();

    bool start();

private:
    void setFreqBand(std::string region);

    LayoutScrollSelect* _menu;
    std::vector<std::string> _regions;
    const char* _file_cp;
};

#endif
