#include "CmdFrequencyBand.h"
#include "ChannelPlans.h"
CmdFrequencyBand::CmdFrequencyBand(mDot* dot, mts::MTSSerial& serial)
    : Command(dot,"Current Frequency Band", "AT+FREQ", "Select Frequency Band 'US915', 'AU915', 'EU868', 'AS923', 'AS923-JAPAN','KR920', or 'IN865'")
    , _serial(serial)
{
      _help = std::string(text()) + ": " + std::string(desc());
      _usage = "";
      _queryable = true;
}

uint32_t CmdFrequencyBand::action(std::vector<std::string> args)
                                  {
    if (args.size() == 1)
    {
        // using getChannelPlanName here instead of mDot::FrequencyBandStr allows AT firmware to properly display custom channel plan names
        if(_dot->getVerbose())
            _serial.writef("Frequency Band: ");

        _serial.writef("%s\r\n", _dot->getChannelPlanName().c_str());
    }
         
     else if (args.size() == 2)
    {
        std::string band_str = mts::Text::toUpper(args[1]);
        lora::ChannelPlan* plan = _dot->getChannelPlan();
        mDot::mdot_file file = _dot->openUserFile("ChannelPlan", mDot::FM_RDWR);
        _dot->seekUserFile(file, 0, SEEK_SET);
        uint8_t cp[] = {0};

        if (mDot::FrequencyBandStr(lora::ChannelPlan::US915) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_US915();
            cp[0] = CP_US915;
        }
        else if (mDot::FrequencyBandStr(lora::ChannelPlan::AU915) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_AU915();
            cp[0] = CP_AU915;
        }
        else if (mDot::FrequencyBandStr(lora::ChannelPlan::EU868) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_EU868();
             cp[0] = CP_EU868;
        }
        else if (mDot::FrequencyBandStr(lora::ChannelPlan::AS923) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_AS923();
             cp[0] = CP_AS923;
	}
        else if (mDot::FrequencyBandStr(lora::ChannelPlan::KR920) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_KR920();
             cp[0] = CP_KR920;
        }
        else if (mDot::FrequencyBandStr(lora::ChannelPlan::IN865) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_IN865();
             cp[0] = CP_IN865;
        }
	else if (mDot::FrequencyBandStr(lora::ChannelPlan::AS923_JAPAN) == band_str) {
            if(plan != NULL) delete plan;
            plan = new lora::ChannelPlan_AS923_Japan();
             cp[0] = CP_AS923_JAPAN;
        }

        if(cp[0] > 0) {
            _dot->writeUserFile(file, cp, 1);
        }
        _dot->closeUserFile(file);

        _serial.writef("Setting Plan \r\n");

        if (_dot->setChannelPlan(plan) != mDot::MDOT_OK) {
            setErrorMessage(_dot->getLastError());
            return 1;
        }
    }
    return 0;
}

bool CmdFrequencyBand::verify(std::vector<std::string> args)
                              {
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        std::string band = mts::Text::toUpper(args[1]);

        if (mDot::FrequencyBandStr(lora::ChannelPlan::US915) != band &&
            mDot::FrequencyBandStr(lora::ChannelPlan::AU915) != band &&
            mDot::FrequencyBandStr(lora::ChannelPlan::EU868) != band &&
            mDot::FrequencyBandStr(lora::ChannelPlan::AS923) != band &&
            mDot::FrequencyBandStr(lora::ChannelPlan::KR920) != band &&
            mDot::FrequencyBandStr(lora::ChannelPlan::IN865) != band &&
            mDot::FrequencyBandStr(lora::ChannelPlan::AS923_JAPAN) != band)
        {
            setErrorMessage("Invalid parameter, expects (US915,AU915,EU868,AS923,AS923-JAPAN,KR920,IN865)");
            return false;
        }
    return true;
    }
}
