#include "mbed.h"
#include "stm32l0xx_hal_iwdg.h"

/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/
DigitalOut led(D7);
DigitalOut myBlueLed(PA_11);
DigitalOut relayPin(PB_10);

#define RCC_HSE_TIMEOUT_VALUE_1 (1000)
#define RCC_HSI_TIMEOUT_VALUE_1 (1000)
#define RCC_MSI_TIMEOUT_VALUE_1 (1000)
#define RCC_LSI_TIMEOUT_VALUE_1 (1000)
#define RCC_HSI48_TIMEOUT_VALUE_1 (1000)
#define RCC_LSE_TIMEOUT_VALUE_1 (1000)
#define RCC_PLL_TIMEOUT_VALUE_1 (1000)
#define RCC_DBP_TIMEOUT_VALUE_1 (1000)

HAL_StatusTypeDef HAL_RCC_OscConfig_1(RCC_OscInitTypeDef  *RCC_OscInitStruct)
{

   uint32_t tickstart = 0U;   
 
  /* Check the parameters */
  assert_param(RCC_OscInitStruct != NULL);
  assert_param(IS_RCC_OSCILLATORTYPE(RCC_OscInitStruct->OscillatorType));
  /*------------------------------- HSE Configuration ------------------------*/ 
  if(((RCC_OscInitStruct->OscillatorType) & RCC_OSCILLATORTYPE_HSE) == RCC_OSCILLATORTYPE_HSE)
  {
    /* Check the parameters */
    assert_param(IS_RCC_HSE(RCC_OscInitStruct->HSEState));
    /* When the HSE is used as system clock or clock source for PLL in these cases HSE will not disabled */
    if((__HAL_RCC_GET_SYSCLK_SOURCE() == RCC_SYSCLKSOURCE_STATUS_HSE) || ((__HAL_RCC_GET_SYSCLK_SOURCE() == RCC_SYSCLKSOURCE_STATUS_PLLCLK) && ((RCC->CFGR & RCC_CFGR_PLLSRC) == RCC_CFGR_PLLSRC_HSE)))
    {
      if((__HAL_RCC_GET_FLAG(RCC_FLAG_HSERDY) != RESET) && (RCC_OscInitStruct->HSEState == RCC_HSE_OFF))
      {
        return HAL_ERROR;
      }
    }
    else
    {
      /* Set the new HSE configuration ---------------------------------------*/
      __HAL_RCC_HSE_CONFIG(RCC_OscInitStruct->HSEState);
      
      /* Check the HSE State */
      if((RCC_OscInitStruct->HSEState) != RCC_HSE_OFF)
      {
        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till HSE is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_HSERDY) == RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_HSE_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        }      
      }
      else
      {
        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till HSE is disabled */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_HSERDY) != RESET)
        {
           if((HAL_GetTick() - tickstart ) > RCC_HSE_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        }
      }
    }
  }
  /*----------------------------- HSI Configuration --------------------------*/ 
  if(((RCC_OscInitStruct->OscillatorType) & RCC_OSCILLATORTYPE_HSI) == RCC_OSCILLATORTYPE_HSI)
  {
    /* Check the parameters */
    assert_param(IS_RCC_HSI(RCC_OscInitStruct->HSIState));
    assert_param(IS_RCC_CALIBRATION_VALUE(RCC_OscInitStruct->HSICalibrationValue));
    
    /* When the HSI is used as system clock it will not disabled */
    if((__HAL_RCC_GET_SYSCLK_SOURCE() == RCC_SYSCLKSOURCE_STATUS_HSI) || ((__HAL_RCC_GET_SYSCLK_SOURCE() == RCC_SYSCLKSOURCE_STATUS_PLLCLK) && ((RCC->CFGR & RCC_CFGR_PLLSRC) == RCC_CFGR_PLLSRC_HSI)))
    {
      /* When HSI is used as system clock it will not disabled */
      if((__HAL_RCC_GET_FLAG(RCC_FLAG_HSIRDY) != RESET) && (RCC_OscInitStruct->HSIState != RCC_HSI_ON))
      {
        return HAL_ERROR;
      }
      /* Otherwise, just the calibration is allowed */
      else
      {
        /* Adjusts the Internal High Speed oscillator (HSI) calibration value.*/
        __HAL_RCC_HSI_CALIBRATIONVALUE_ADJUST(RCC_OscInitStruct->HSICalibrationValue);
      }
    }
    else
    {
      /* Check the HSI State */
      if((RCC_OscInitStruct->HSIState)!= RCC_HSI_OFF)
      {
        /* Enable the Internal High Speed oscillator (HSI or HSIdiv4 */
        __HAL_RCC_HSI_CONFIG(RCC_OscInitStruct->HSIState);
        
        /* Get Start Tick*/
        tickstart = HAL_GetTick();
      
        /* Wait till HSI is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_HSIRDY) == RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_HSI_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        } 
                
        /* Adjusts the Internal High Speed oscillator (HSI) calibration value.*/
        __HAL_RCC_HSI_CALIBRATIONVALUE_ADJUST(RCC_OscInitStruct->HSICalibrationValue);
      }
      else
      {
        /* Disable the Internal High Speed oscillator (HSI). */
        __HAL_RCC_HSI_CONFIG(RCC_OscInitStruct->HSIState);
       
        /* Get Start Tick*/
        tickstart = HAL_GetTick();
      
        /* Wait till HSI is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_HSIRDY) != RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_HSI_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        } 
      }
    }
  }
  /*----------------------------- MSI Configuration --------------------------*/ 
  if(((RCC_OscInitStruct->OscillatorType) & RCC_OSCILLATORTYPE_MSI) == RCC_OSCILLATORTYPE_MSI)
  {
        
    /* When the MSI is used as system clock it will not be disabled */
    if((__HAL_RCC_GET_SYSCLK_SOURCE() == RCC_CFGR_SWS_MSI) )
    {
      if((__HAL_RCC_GET_FLAG(RCC_FLAG_MSIRDY) != RESET) && (RCC_OscInitStruct->MSIState == RCC_MSI_OFF))
      {
        return HAL_ERROR;
      }
      
       /* Otherwise, just the calibration and MSI range change are allowed */
      else
      {
       /* Check MSICalibrationValue and MSIClockRange input parameters */
        assert_param(IS_RCC_MSICALIBRATION_VALUE(RCC_OscInitStruct->MSICalibrationValue));
        assert_param(IS_RCC_MSI_CLOCK_RANGE(RCC_OscInitStruct->MSIClockRange));

       /* Selects the Multiple Speed oscillator (MSI) clock range .*/
        __HAL_RCC_MSI_RANGE_CONFIG (RCC_OscInitStruct->MSIClockRange);   
        /* Adjusts the Multiple Speed oscillator (MSI) calibration value.*/
        __HAL_RCC_MSI_CALIBRATIONVALUE_ADJUST(RCC_OscInitStruct->MSICalibrationValue);

        /* Update the SystemCoreClock global variable */
        SystemCoreClock =  HAL_RCC_GetSysClockFreq() >> AHBPrescTable[((RCC->CFGR & RCC_CFGR_HPRE) >> 4)];
         
        /* Configure the source of time base considering new system clocks settings*/
        HAL_InitTick (TICK_INT_PRIORITY);
      }
    }
    else
    {
      /* Check the MSI State */
      assert_param(IS_RCC_MSI(RCC_OscInitStruct->MSIState));
      if((RCC_OscInitStruct->MSIState)!= RCC_MSI_OFF)
      {
        /* Enable the Internal High Speed oscillator (MSI). */
        __HAL_RCC_MSI_ENABLE();
        
        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till MSI is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_MSIRDY) == RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_MSI_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        }

        /* Check MSICalibrationValue and MSIClockRange input parameters */
        assert_param(IS_RCC_MSICALIBRATION_VALUE(RCC_OscInitStruct->MSICalibrationValue));
        assert_param(IS_RCC_MSI_CLOCK_RANGE(RCC_OscInitStruct->MSIClockRange));

         /* Selects the Multiple Speed oscillator (MSI) clock range .*/
        __HAL_RCC_MSI_RANGE_CONFIG (RCC_OscInitStruct->MSIClockRange);   
         /* Adjusts the Multiple Speed oscillator (MSI) calibration value.*/
        __HAL_RCC_MSI_CALIBRATIONVALUE_ADJUST(RCC_OscInitStruct->MSICalibrationValue);
        
      }
      else
      {
        /* Disable the Internal High Speed oscillator (MSI). */
        __HAL_RCC_MSI_DISABLE();
        
        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till MSI is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_MSIRDY) != RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_MSI_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        } 
      }
    }
  }
  /*------------------------------ LSI Configuration -------------------------*/ 
  if(((RCC_OscInitStruct->OscillatorType) & RCC_OSCILLATORTYPE_LSI) == RCC_OSCILLATORTYPE_LSI)
  {
    /* Check the parameters */
    assert_param(IS_RCC_LSI(RCC_OscInitStruct->LSIState));
    
    /* Check the LSI State */
    if((RCC_OscInitStruct->LSIState)!= RCC_LSI_OFF)
    {
      /* Enable the Internal Low Speed oscillator (LSI). */
      __HAL_RCC_LSI_ENABLE();
      
      /* Get timeout */
      tickstart = HAL_GetTick();
      
      /* Wait till LSI is ready */  
      while(__HAL_RCC_GET_FLAG(RCC_FLAG_LSIRDY) == RESET)
      {
        if((HAL_GetTick() - tickstart ) > RCC_LSI_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }      
      } 
    }
    else
    {
      /* Disable the Internal Low Speed oscillator (LSI). */
      __HAL_RCC_LSI_DISABLE();
      
      /* Get timeout */
      tickstart = HAL_GetTick();
      
      /* Wait till LSI is ready */  
      while(__HAL_RCC_GET_FLAG(RCC_FLAG_LSIRDY) != RESET)
      {
        if((HAL_GetTick() - tickstart ) > RCC_LSI_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }      
      } 
    }
  }
  
#if !defined (STM32L011xx) && !defined (STM32L021xx) && !defined (STM32L031xx) && !defined (STM32L041xx) && !defined(STM32L051xx) && !defined(STM32L061xx) && !defined(STM32L071xx) && !defined(STM32L081xx)  
   /*------------------------------ HSI48 Configuration -------------------------*/ 
  if(((RCC_OscInitStruct->OscillatorType) & RCC_OSCILLATORTYPE_HSI48) == RCC_OSCILLATORTYPE_HSI48)
  {
    /* Check the parameters */
    assert_param(IS_RCC_HSI48(RCC_OscInitStruct->HSI48State));
    
    /* Check the HSI48 State */
    if((RCC_OscInitStruct->HSI48State)!= RCC_HSI48_OFF)
    {
      /* Enable the Internal Low Speed oscillator (HSI48). */
      __HAL_RCC_HSI48_ENABLE();
      
      /* Get timeout */
      tickstart = HAL_GetTick();
      
      /* Wait till HSI48 is ready */  
      while(__HAL_RCC_GET_FLAG(RCC_FLAG_HSI48RDY) == RESET)
      {
        if((HAL_GetTick() - tickstart ) > RCC_HSI48_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }      
      } 
    }
    else
    {
      /* Disable the Internal Low Speed oscillator (HSI48). */
      __HAL_RCC_HSI48_DISABLE();
      
      /* Get timeout */
      tickstart = HAL_GetTick();
      
      /* Wait till HSI48 is ready */  
      while(__HAL_RCC_GET_FLAG(RCC_FLAG_HSI48RDY) != RESET)
      {
        if((HAL_GetTick() - tickstart ) > RCC_HSI48_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }      
      } 
    }
  }
#endif /* !defined (STM32L011xx) && !defined (STM32L021xx) && !(STM32L031xx) && !(STM32L041xx) && !defined(STM32L051xx) && !defined(STM32L061xx) && !defined(STM32L071xx) && !defined(STM32L081xx)*/  
  
  /*------------------------------ LSE Configuration -------------------------*/ 
  if(((RCC_OscInitStruct->OscillatorType) & RCC_OSCILLATORTYPE_LSE) == RCC_OSCILLATORTYPE_LSE)
  {
    FlagStatus       pwrclkchanged = RESET;
    FlagStatus       backupchanged = RESET;
    
    /* Check the parameters */
    assert_param(IS_RCC_LSE(RCC_OscInitStruct->LSEState));

    /* Update LSE configuration in Backup Domain control register    */
    /* Requires to enable write access to Backup Domain of necessary */
    if(HAL_IS_BIT_CLR(RCC->APB1ENR, RCC_APB1ENR_PWREN))
    {
      __HAL_RCC_PWR_CLK_ENABLE();
      pwrclkchanged = SET;
    }
    
    if(HAL_IS_BIT_CLR(PWR->CR, PWR_CR_DBP))
    {
      /* Enable write access to Backup domain */
      SET_BIT(PWR->CR, PWR_CR_DBP);
      backupchanged = SET;
      
      /* Wait for Backup domain Write protection disable */
      tickstart = HAL_GetTick();

      while(HAL_IS_BIT_CLR(PWR->CR, PWR_CR_DBP))
      {
        if((HAL_GetTick() - tickstart) > RCC_DBP_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }
      }
    }
    
    /* Set the new LSE configuration -----------------------------------------*/
    __HAL_RCC_LSE_CONFIG(RCC_OscInitStruct->LSEState);

    /* Check the LSE State */
    if((RCC_OscInitStruct->LSEState) != RCC_LSE_OFF)
    {     
      /* Get timeout */
      tickstart = HAL_GetTick();
      
      /* Wait till LSE is ready */  
      while(__HAL_RCC_GET_FLAG(RCC_FLAG_LSERDY) == RESET)
      {
        if((HAL_GetTick() - tickstart ) > RCC_LSE_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }      
      }
    }
    else
    {
      /* Get timeout */
      tickstart = HAL_GetTick();
      
      /* Wait till LSE is ready */  
      while(__HAL_RCC_GET_FLAG(RCC_FLAG_LSERDY) != RESET)
      {
        if((HAL_GetTick() - tickstart ) > RCC_LSE_TIMEOUT_VALUE_1)
        {
          return HAL_TIMEOUT;
        }      
      }
    }

    /* Requires to disable write access to Backup Domain of necessary */
    if(backupchanged == SET)
    {
      CLEAR_BIT(PWR->CR, PWR_CR_DBP);
    }
    if(pwrclkchanged == SET)
    {
      __HAL_RCC_PWR_CLK_DISABLE();
    }
  }
  /*-------------------------------- PLL Configuration -----------------------*/
  /* Check the parameters */
  assert_param(IS_RCC_PLL(RCC_OscInitStruct->PLL.PLLState));
  if ((RCC_OscInitStruct->PLL.PLLState) != RCC_PLL_NONE)
  {
    /* Check if the PLL is used as system clock or not */
    if(__HAL_RCC_GET_SYSCLK_SOURCE() != RCC_SYSCLKSOURCE_STATUS_PLLCLK)
    { 
      if((RCC_OscInitStruct->PLL.PLLState) == RCC_PLL_ON)
      {
        /* Check the parameters */
        assert_param(IS_RCC_PLLSOURCE(RCC_OscInitStruct->PLL.PLLSource));
        assert_param(IS_RCC_PLL_MUL(RCC_OscInitStruct->PLL.PLLMUL));
        assert_param(IS_RCC_PLL_DIV(RCC_OscInitStruct->PLL.PLLDIV));
        
        
        /* Disable the main PLL. */
        __HAL_RCC_PLL_DISABLE();
        
        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till PLL is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_PLLRDY) != RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_PLL_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        }        

        /* Configure the main PLL clock source, multiplication and division factors. */
        __HAL_RCC_PLL_CONFIG(RCC_OscInitStruct->PLL.PLLSource,
                             RCC_OscInitStruct->PLL.PLLMUL,
                             RCC_OscInitStruct->PLL.PLLDIV);
        /* Enable the main PLL. */
        __HAL_RCC_PLL_ENABLE();

        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till PLL is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_PLLRDY) == RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_PLL_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        }
      }
      else
      {
        /* Disable the main PLL. */
        __HAL_RCC_PLL_DISABLE();       
        /* Get timeout */
        tickstart = HAL_GetTick();
      
        /* Wait till PLL is ready */  
        while(__HAL_RCC_GET_FLAG(RCC_FLAG_PLLRDY) != RESET)
        {
          if((HAL_GetTick() - tickstart ) > RCC_PLL_TIMEOUT_VALUE_1)
          {
            return HAL_TIMEOUT;
          }      
        }
      }
    }
    else
    {
      return HAL_ERROR;
    }
  }
  return HAL_OK;
}

int MY_SetSysClock_PLL_HSE(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;

    /* Enable HSE and activate PLL with HSE as source */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState       = RCC_HSE_ON; /* External 8 MHz xtal on OSC_IN/OSC_OUT */

    // PLLCLK = (8 MHz * 8)/2 = 32 MHz
    RCC_OscInitStruct.PLL.PLLState        = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource       = RCC_PLLSOURCE_HSE;
    RCC_OscInitStruct.PLL.PLLMUL          = RCC_PLLMUL_8;
    RCC_OscInitStruct.PLL.PLLDIV          = RCC_PLLDIV_2;
    if (HAL_RCC_OscConfig_1(&RCC_OscInitStruct) != HAL_OK) {
        return (-1); // FAIL
    }

    /* Select PLL as system clock source and configure the HCLK, PCLK1 and PCLK2 clocks dividers */
    RCC_ClkInitStruct.ClockType      = (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
    RCC_ClkInitStruct.SYSCLKSource   = RCC_SYSCLKSOURCE_PLLCLK; // 32 MHz
    RCC_ClkInitStruct.AHBCLKDivider  = RCC_SYSCLK_DIV1;         // 32 MHz
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;           // 32 MHz
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;           // 32 MHz
    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK) {
        return (-2); // FAIL
    }

    /* Enable HSE and activate PLL with HSE as source */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI48|RCC_OSCILLATORTYPE_HSI|RCC_OSCILLATORTYPE_MSI;
    RCC_OscInitStruct.HSIState       = RCC_HSI_OFF;
    RCC_OscInitStruct.MSIState       = RCC_MSI_OFF;
    RCC_OscInitStruct.HSI48State     = RCC_HSI48_OFF;
    RCC_OscInitStruct.PLL.PLLState   = RCC_PLL_NONE;
    if (HAL_RCC_OscConfig_1(&RCC_OscInitStruct) != HAL_OK) {
        return (-3); // FAIL
    }
        
    return 0; // OK
}

void my_patch(void)
{
    int retVal;
    
    // Put device into default clock, i.e using MSI = 2MHz
    HAL_RCC_DeInit();
    
    // Enable HSE clock
    retVal = MY_SetSysClock_PLL_HSE();
    if(retVal< 0)
    {
        //pc.printf("Failed to start HSE, ERR= %d\r\n", retVal);
        
        // indicate error
        while(1)
        {
            led = !led;
            wait(0.2);
        }
    }    
}

int main()
{
    Serial pc(SERIAL_TX, SERIAL_RX);
    pc.baud(115200);


//    pc.printf("TIMEOUT HSE=%d PLL=%d HSI=%d MSI=%d LSI=%d LSE=%d\r\n",\
//    RCC_HSE_TIMEOUT_VALUE, RCC_PLL_TIMEOUT_VALUE,RCC_HSI_TIMEOUT_VALUE,RCC_MSI_TIMEOUT_VALUE,\
//    RCC_LSI_TIMEOUT_VALUE,RCC_LSE_TIMEOUT_VALUE);

    pc.printf("mbed-os-rev: %d.%d.%d   lib-rev: %d\r\n", \
            MBED_MAJOR_VERSION, MBED_MINOR_VERSION,MBED_PATCH_VERSION,MBED_LIBRARY_VERSION);
    pc.printf("BUILD= %s, SysClock= %d, RCC= %0X CSR= %0X\r\n", __TIME__, SystemCoreClock, RCC->CR, RCC->CSR);
    
    
    my_patch();
     pc.printf("NEW BUILD= %s, SysClock= %d, RCC= %0X CSR= %0X\r\n", __TIME__, SystemCoreClock, RCC->CR, RCC->CSR);
    wait(3);
    
    int i = 1;


        myBlueLed = 1; // LED is ON    
        wait(0.5); // 500 ms
        myBlueLed = 0; // LED is ON  
        wait(0.5); // 500 ms
        relayPin = 1; // LED is ON
        wait(0.5); // 500 ms
        relayPin = 0; // LED is ON
        wait(0.5); // 500 ms

    IWDG_HandleTypeDef wd;
    wd.Instance = IWDG;
    wd.Init.Prescaler = IWDG_PRESCALER_256; //About 32s
    wd.Init.Reload = 0x0FFF;
    wd.Init.Window = 0x0FFF;
    HAL_IWDG_Init(&wd);
    pc.printf("initialized watchdog CSR= %0X IWDG->SR= %0X\r\n", RCC->CSR, IWDG->SR);

    IWDG->KR = 0x00005555;
    pc.printf(">> IWDG PR= %0X RLR= %0X SR= %0X\r\n", IWDG->PR, IWDG->RLR, IWDG->SR);    


    while(1) {
        wait(1); // 1 second
        led = !led;
        relayPin = !relayPin; // LED is ON
              
        if (i == 15) { 
            
            //https://github.com/ARMmbed/mbed-os/blob/mbed_lib_rev164/targets/TARGET_STM/TARGET_STM32L0/device/stm32l0xx_hal_iwdg.c
            /* Enable write access to IWDG_PR, IWDG_RLR and IWDG_WINR registers by writing 0x5555 in KR 
            *  This is not done in HAL_IWDG_Refresh() (I THINK SO :->)
            */

            HAL_IWDG_Refresh(&wd);
            pc.printf("Fed the dog\r\n");
        }
        pc.printf("This program runs since %d seconds.\r\n", i++);
    }

    pc.printf("should never reach here\n");
}
