#include "mbed.h"
#include "stm32l0xx_hal_iwdg.h"

/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/
DigitalOut led(D7);
DigitalOut myBlueLed(PA_11);
DigitalOut relayPin(PB_10);

    Serial pc(SERIAL_TX, SERIAL_RX);


int MY_SetSysClock_PLL_HSE(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;

    /* Enable HSE and activate PLL with HSE as source */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState       = RCC_HSE_ON; /* External 8 MHz xtal on OSC_IN/OSC_OUT */

    // PLLCLK = (8 MHz * 8)/2 = 32 MHz
    RCC_OscInitStruct.PLL.PLLState        = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource       = RCC_PLLSOURCE_HSE;
    RCC_OscInitStruct.PLL.PLLMUL          = RCC_PLLMUL_8;
    RCC_OscInitStruct.PLL.PLLDIV          = RCC_PLLDIV_2;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        relayPin = 1;
        return (-1); // FAIL
    }

    led = 0;

    /* Select PLL as system clock source and configure the HCLK, PCLK1 and PCLK2 clocks dividers */
    RCC_ClkInitStruct.ClockType      = (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
    RCC_ClkInitStruct.SYSCLKSource   = RCC_SYSCLKSOURCE_PLLCLK; // 32 MHz
    RCC_ClkInitStruct.AHBCLKDivider  = RCC_SYSCLK_DIV1;         // 32 MHz
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;           // 32 MHz
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;           // 32 MHz
    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_1) != HAL_OK) {
        return (-2); // FAIL
    }

    myBlueLed = 0;

    /* Enable HSE and activate PLL with HSE as source */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI48|RCC_OSCILLATORTYPE_HSI|RCC_OSCILLATORTYPE_MSI;
    RCC_OscInitStruct.HSIState       = RCC_HSI_OFF;
    RCC_OscInitStruct.MSIState       = RCC_MSI_OFF;
    RCC_OscInitStruct.HSI48State     = RCC_HSI48_OFF;
    RCC_OscInitStruct.PLL.PLLState   = RCC_PLL_NONE;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        return (-3); // FAIL
    }
    
    relayPin = 0;
    
    return 0; // OK
}

void my_patch(void)
{
    int retVal;
    
    relayPin = 1;
    led = 1;
    myBlueLed = 1;
    
    // Put device into default clock, i.e using MSI = 2MHz
    HAL_RCC_DeInit();
    
    // Enable HSE clock
    retVal = MY_SetSysClock_PLL_HSE();
    if(retVal == -1)
    {   
        while(1)
        {
            led = !led;            
            wait(1);
        }
    }
    else if(retVal == -2)
    {
        while(1)
        {
            myBlueLed = !myBlueLed;            
            wait(1);
        }        
    }   
    else if(retVal == -3)
    {
        while(1)
        {
            relayPin = !relayPin;
            led = !led;            
            myBlueLed = !myBlueLed;            
            wait(1);    
        }
    } 
}

void reset_cause(unsigned int csr){

    if(csr & (1U<<24))
        pc.printf("!!! FIREWALL RESET\r\n");
    if(csr & (1U<<25))
        pc.printf("!!! OBL RESET\r\n");
    if(csr & (1U<<26))
        pc.printf("!!! PIN RESET\r\n");
    if(csr & (1U<<27))
        pc.printf("!!! POR RESET\r\n");
    if(csr & (1U<<28))
        pc.printf("!!! SOFTWARE RESET\r\n");
    if(csr & (1U<<29))
        pc.printf("!!! IWDG RESET\r\n");
    if(csr & (1U<<30))
        pc.printf("!!! WWDG RESET\r\n");
    if(csr & (1U<<31))
        pc.printf("!!! LPWR RESET\r\n");

    RCC->CSR |= (1U<<23); // clear reset cause
}

int main()
{
//    Serial pc(SERIAL_TX, SERIAL_RX);
//    pc.baud(115200);

//    pc.printf("mbed-os-rev: %d.%d.%d   lib-rev: %d\r\n", \
//            MBED_MAJOR_VERSION, MBED_MINOR_VERSION,MBED_PATCH_VERSION,MBED_LIBRARY_VERSION);
//    pc.printf("BUILD= %s %s\r\n\r\n", __TIME__, __DATE__);
    
//    pc.printf("OLD SysClock= %d, CR= %08X CSR= %08X\r\n\r\n", SystemCoreClock, RCC->CR, RCC->CSR);

    my_patch();
    pc.baud(115200);

    reset_cause(RCC->CSR);

    pc.printf("NEW SysClock= %d, CR= %08X CSR= %08X\r\n\r\n", SystemCoreClock, RCC->CR, RCC->CSR);
    
    
    wait(3);

    IWDG_HandleTypeDef wd;
    wd.Instance = IWDG;
    wd.Init.Prescaler = IWDG_PRESCALER_256; //About 32s
    wd.Init.Reload = 0x0FFF;
    wd.Init.Window = 0x0FFF;
    HAL_IWDG_Init(&wd);
    pc.printf("initialized watchdog CSR= %0X IWDG->SR= %0X\r\n", RCC->CSR, IWDG->SR);

    IWDG->KR = 0x00005555;
    pc.printf(">> IWDG PR= %0X RLR= %0X SR= %0X\r\n", IWDG->PR, IWDG->RLR, IWDG->SR);    

    int i = 1;


        myBlueLed = 1; // LED is ON    
        wait(0.5); // 500 ms
        myBlueLed = 0; // LED is ON  
        wait(0.5); // 500 ms
        relayPin = 1; // LED is ON
        wait(0.5); // 500 ms
        relayPin = 0; // LED is ON
        wait(0.5); // 500 ms

                
//    pc.printf("Hello World 2 !\r\n");

    while(1) {
        wait(1); // 1 second
        led = !led;
        relayPin = !relayPin; // LED is ON   
        
        if (i == 15) { 
            
            //https://github.com/ARMmbed/mbed-os/blob/mbed_lib_rev164/targets/TARGET_STM/TARGET_STM32L0/device/stm32l0xx_hal_iwdg.c
            /* Enable write access to IWDG_PR, IWDG_RLR and IWDG_WINR registers by writing 0x5555 in KR 
            *  This is not done in HAL_IWDG_Refresh() (I THINK SO :->)
            */
//            IWDG_ENABLE_WRITE_ACCESS(&wd); 
//            IWDG->KR = 0x0000AAAA;
        
            HAL_IWDG_Refresh(&wd);
            pc.printf("Fed the dog\r\n");
        }
        pc.printf("This program runs since %d seconds.\r\n", i++);
    }

    pc.printf("should never reach here\n");
}
