/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     1

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

/*!
 * IEEE Organizationally Unique Identifier ( OUI ) (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x00, 0x52, 0xF7

/*!
 * Mote device IEEE EUI (big endian)
 */
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xF7, 0x41, 0x06, 0x67, 0x01, 0x00 }  // Dev 1
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x02, 0x00 }  // Dev 2
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x03, 0x00 }  // Dev 3
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x04, 0x00 }  // Dev 4
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x05, 0x00 }  // Dev 5
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x06, 0x00 }  // Dev 6
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x07, 0x00 }  // Dev 7
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x08, 0x00 }  // Dev 8
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x09, 0x00 }  // Dev 9
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x10, 0x00 }  // Dev 10
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x11, 0x00 }  // Dev 11
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x12, 0x00 }  // Dev 12
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x13, 0x00 }  // Dev 13
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x14, 0x00 }  // Dev 14
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x15, 0x00 }  // Dev 15
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x16, 0x00 }  // Dev 16
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x17, 0x00 }  // Dev 17
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x18, 0x00 }  // Dev 18
#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x19, 0x00 }  // Dev 19
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x20, 0x00 }  // Dev 20
//#define LORAWAN_DEVICE_EUI                          { 0x00, 0x52, 0xf7, 0x41, 0x06, 0x67, 0x21, 0x00 }  // Dev 21

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x01, 0x9D, 0xAC }

/*!
 * AES encryption/decryption cipher application key
 */
//#define LORAWAN_APPLICATION_KEY           { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0xb1, 0x0e }  // Dev 14

//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x01, 0x00 }  // Dev 1
//55 4d a0 a9 69 32 68 1f ca 06 2b c5 c2 54 01 00
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x02, 0x00 }  // Dev 2
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x03, 0x00 }  // Dev 3
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x04, 0x00 }  // Dev 4
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x05, 0x00 }  // Dev 5
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x06, 0x00 }  // Dev 6
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x07, 0x00 }  // Dev 7
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x08, 0x00 }  // Dev 8
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x09, 0x00 }  // Dev 9
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x10, 0x00 }  // Dev 10
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x11, 0x00 }  // Dev 11
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x12, 0x00 }  // Dev 12
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x13, 0x00 }  // Dev 13
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x14, 0x00 }  // Dev 14
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x15, 0x00 }  // Dev 15
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x16, 0x00 }  // Dev 16
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x17, 0x00 }  // Dev 17
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x18, 0x00 }  // Dev 18
#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x19, 0x00 }  // Dev 19
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x20, 0x00 }  // Dev 20
//#define LORAWAN_APPLICATION_KEY         { 0x55, 0x4d, 0xa0, 0xa9, 0x69, 0x32, 0x68, 0x1f, 0xca, 0x06, 0x2b, 0xc5, 0xc2, 0x54, 0x21, 0x00 }  // Dev 21





/*!
 * Current network ID
 */
#define LORAWAN_NETWORK_ID                          ( uint32_t )0

/*!
 * Device address on the network (big endian)
 */
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x12345678

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

#endif // __LORA_COMMISSIONING_H__
