
#include "mbed.h"
#include "Si7021.h"

// I2C Definition
I2C spd800_i2c(PB_9, PB_8); //sda, scl

DigitalOut myGreenLed(D7); // ON = Lora Connected
DigitalOut myBlueLed(PA_11);  // Blink twice = Sends data or increments counter value Pelase proceed
DigitalOut myRedLed(PB_15);

DigitalOut LoraPin(PB_14);
DigitalOut I2C1Pin(PB_12);
DigitalOut I2C2Pin(PB_13);
DigitalOut PWEN(PC_8);

DigitalOut Pin51(PC_10);
DigitalOut Pin52(PC_11);
DigitalOut Pin53(PC_12);
DigitalOut RM(PC_2);
DigitalOut Light2(PC_0);
DigitalOut Light1(PA_1);


AnalogIn BAT_PIN_1(PC_5);
AnalogIn BAT_PIN(A2);
AnalogIn LIGHT_1_PIN(A1);
AnalogIn LIGHT_2_PIN(A5);
AnalogIn RH_PIN(PC_2);
AnalogIn VCE_PIN(PB_1);
DigitalOut relaypin(D6);
AnalogIn Exit(PC_4);



int count =0;
float Vref = 3.342;


DigitalOut si7021_power_pin(PB_2);

Serial pc(SERIAL_TX, SERIAL_RX,115200);

void print_array(char *array, int len) {
    for (int idx = 0; idx < len; idx++) {
         pc.printf("%x", array[idx]);
    } 
    pc.printf("\r\n");
}

float read_pressure_measurement() {
    char output[9];
    
    // Read measurements
    if ( spd800_i2c.read((0x25 << 1), output, 9) != 0 ) { // read from register
        pc.printf("FAILED TO READ PRESSURE: %d\r\n", spd800_i2c.read((0x25 << 1), output, 9));
    }
    //print_array(output, 9);
    
    // Interpret
    int16_t diffPressureTicks = (output[0] << 8) | output[1];
    // int16_t temperatureTicks = (output[3] << 8) | output[4];
    uint16_t scaleFactorDiffPressure = (output[6] << 8) | output[7];
    
    float diffPressure = (float)diffPressureTicks / (float)scaleFactorDiffPressure;
    
    return diffPressure;
}

int main() {
    pc.printf("Starting Pressure/Temp/Humidity Sensor Test..\r\n");
    
   PWEN = 1; 
    
    myGreenLed = 1; // LED is ON 
    wait(0.25);
    myGreenLed = 0; // LED is ON 
    wait(0.25);
        
    myRedLed = 1; // LED is ON  
    wait(0.25);
    myRedLed = 0; // LED is ON  
    wait(0.25);    

    myBlueLed = 1;
    wait(0.25);    
    myBlueLed = 0;
    wait(0.25);    
        
 
        
    for(int i=0; i<5; i++){
        
    myGreenLed = 1; // LED is ON   
  //   PWEN = 1;  
    LoraPin = 1; 
    I2C1Pin = 1; 
    I2C2Pin = 1; 
    wait(1);
    myGreenLed = 0; // LED is ON

    myRedLed = 1; // LED is ON  
  //  PWEN = 0;   
    LoraPin = 0; 
    I2C1Pin = 0; 
    I2C2Pin = 0; 
    wait(1);
    myRedLed = 0;// LED is ON   
    
    pc.printf("%d\t",count);
    
    float meas_Vbat = BAT_PIN.read();
    float Vbat = meas_Vbat*Vref;
    pc.printf("%.03f\n\r", Vbat);
    
    wait(1);
    count++;
    
    }
        
    wait(1);
    
    char cont_measure_command[2] = {0x36, 0x1E};
    char single_measure_command[2] = {0x36, 0x2F}; 
    char stop_command[2] = {0x3F, 0xF9};
    char reset_command[1] = {0x06};
    
    // Reset the pressure sensor
 //   pc.printf("Resetting Pressure Sensor...\r\n");
    if ( spd800_i2c.write(0x00, reset_command, 1) != 0 ) {
        pc.printf("RESET FAILED!\r\n");        
    }
    
    // set up SHT31
    si7021_power_pin = 1;
//  Si7021 si7021 = Si7021(PB_9, PB_8);
    Si7021 si7021 = Si7021(PB_11, PB_10);
     
    wait(1);
    
    count=0;  
                 
                 
    // Take a few manual measurements
    while( true ) {
        
        
    pc.printf("%d\t",count);
    float meas_Vbat = BAT_PIN.read();
    float Vbat = meas_Vbat*Vref;
    pc.printf("%.03f\n\r", Vbat);
    
    wait(1);
    count++;  
        
        
        
    //    myRedLed = 1; // LED is ON  
    //    wait(0.1);
        myRedLed = 0; // LED is ON 
        
        LoraPin = 0; 
        I2C1Pin = 0; 
        I2C2Pin = 0; 
        
        wait(1);
           
 //       pc.printf("\r\n\n");
 //       pc.printf("Measuring Pressure...\r\n");
        if ( spd800_i2c.write((0x25 << 1), single_measure_command, 2) != 0 ) {
            pc.printf("FAILED TO WRITE TO PRESSURE SENSOR\r\n");
        }
        wait(1);
        
               
  //      pc.printf("Measuring Temp/Humidity...\r\n");
        if ( !si7021.check() ) {
  //          pc.printf("TEMP/HUMIDITY SENSOR NOT WORKING\r\n");
        } else {
            si7021.measure();
        }
        
        
  //      pc.printf("Humidity: %d\r\n", si7021.get_humidity());
  //      pc.printf("Temperature: %d\r\n", si7021.get_temperature());
 //       pc.printf("Pressure: %f\r\n", read_pressure_measurement());
        wait(1);
     
        

        myGreenLed = 1; // LED is ON   
        wait(0.1);
        myGreenLed = 0; // LED is ON     
        
        LoraPin = 1; 
        I2C1Pin = 1; 
        I2C2Pin = 1;     
        wait(54);

    }
 
      
}