/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief The software of Vehicle Rear Assistant.
@brief ELEC 2645
@author Aminuddin Omar
@date   APRIL 2015
*/

#ifndef MAIN_H
#define MAIN_H

                                     //Declare libraries to be used 
#include "mbed.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include "N5110.h"
#include "SRF02.h"
#include "beep.h"

/**  
@namespace lcd
@brief GPIO pins for LCD display
@namespace sensor
@brief GPIO pins for SRF02
@namespace buzzer
@brief PWM pin for piezo buzzer
@namespace danger
@brief PWM pin for RED LED
@namespace caution
@brief PWM pin for YELLOW LED
@namespace safe
@brief PWM pin for GREEN LED
@namespace lcdBrightness
@brief PWM pin for LCD backlight
@namespace potBrightness
@brief AnalogIn pin for potentiometer
@namespace button
@brief InterruptIn pin for button
*/                                    
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);                  //(LCD_VCC, sce, rst, dc, mosi, sck, backlight)
SRF02 sensor(p28, p27);
Beep buzzer(p21);                       
PwmOut danger(p24);                                  //danger = red
PwmOut caution(p23);                                 //caution = yellow
PwmOut safe(p22);                                    //safe = green
PwmOut lcdBrightness(p26);                           //lcd backlight (pin26)     
AnalogIn potBrightness(p20);                         //potentiometer (pin20)
InterruptIn button(p17);                             //push button to display value of distance

                                    //variables                            
int distance;             /*!< measure distance between car and object */
int buttonFlag = 0;       /*!< print flag set in ISR */
int displayReading = 0;   /*!< display the value of distance on LCD */

                                     //Initialise all the functions
                                     
/**
Print welcome message when switch is turned on
@param a - set number of letters that can be written including space
@param message - Print HELLO
@param rear - Print REAR
@param assistant - Print ASSISTANT
@param name - Print A.OMAR
@param number - Print 200906568
*/
void welcomeText();

/**
Measure distance between car and objects
@param distance - use SRF02 to measure distance
*/
void getDistance();

/**
Print "CAR" and a block on LCD according to distance measured
@param lcd.drawRect - draw rectangle to represent object 
@param lcd.printString - draw "CAR" to represent car
@param lcd.refresh() - refresh LCD display
@param distanceSafe() - GREEN LED and buzzer is activated in safe mode
@param distanceCaution() - YELLOW LED and buzzer is activated in caution mode
@param distanceDanger() - RED LED and buzzer is activated in danger mode
*/
void readDistance();

/**
This function is called when in safe mode
@param safe - only GREEN LED light up
@brief buzzer is called and beep according to distance
*/
void distanceSafe();

/**
This function is called when in caution mode
@param safe - only YELLOW LED light up
@brief buzzer is called and beep according to distance
*/
void distanceCaution();

/**
This function is called when in danger mode
@param safe - only RED LED light up
@brief buzzer is called and beep according to distance
*/
void distanceDanger();

/**
This function is called when button is pressed
@param buttonFlag - set the button flag to 1
*/
void buttonPressed();


                                    //Print welcome message (letters are print one by one)
void welcomeText()
{     
    int a[9] = {12,18,24,30,36,42,48,54,60};
    const char message[6] = {'H','E','L','L','O','!'};
    char rear[4] = {'R','E','A','R'};
    char assistant[9] = {'A','S','S','I','S','T','A','N','T'};
    char name[6] = {'A','.','O','M','A','R'};
    char number[9] = {'2','0','0','9','0','6','5','6','8'};
    int i;
    for(i=0; i<6; i++) {
        lcd.printChar(message[i],a[i],0);
        wait(0.05);
    }
    for(i=0; i<4; i++) {
        lcd.printChar(rear[i],a[i],2);
        wait(0.05);
    }
    for(i=0; i<9; i++) {
        lcd.printChar(assistant[i],a[i],3);
        wait(0.05);
    }
    for(i=0; i<6; i++) {
        lcd.printChar(name[i],a[i],4);
        wait(0.05);
    }
    for(i=0; i<9; i++) {
        lcd.printChar(number[i],a[i],5);
        wait(0.05);
    }
    lcd.refresh();
    wait(2.5); 
}

                                    //sensor is set to get the distance
void getDistance()
{
    distance = sensor.getDistanceCm();
}

                                    //sensor read distance & lcd display 'CAR' and 'rectangle' 
void readDistance()
{
        if (distance >= 230) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL   lcd.drawRect(76(x),0(y),7(w),48(h),1(type))
        lcd.printString("CAR",5,3); //CAR
        lcd.refresh();
        distanceSafe();
    }
    else if (distance >= 190 & distance <= 229) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL
        lcd.printString("CAR",15,3);//CAR
        lcd.refresh();
        distanceSafe();
    }
    else if (distance >= 150 & distance <= 189) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL
        lcd.printString("CAR",25,3);//CAR
        lcd.refresh();
        distanceSafe();
    }
    else if (distance >= 120 & distance <= 149) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL
        lcd.printString("CAR",30,3);//CAR
        lcd.refresh();
        distanceCaution();
    }
    else if (distance >= 100 & distance <= 119) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL
        lcd.printString("CAR",39,3);//CAR
        lcd.refresh();
        distanceCaution();
    }
    else if (distance >= 70 & distance <= 99) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL
        lcd.printString("CAR",48,3);//CAR
        lcd.refresh();
        distanceCaution();
    }
    else if (distance >=  45& distance <= 69) 
    {
        lcd.drawRect(76,0,7,48,1);  //WALL
        lcd.printString("CAR",55,3);//CAR
        lcd.refresh();
        distanceDanger();
    }
    else if (distance <= 44) 
    {
        lcd.printString("!!STOP!!",25,3);//print "STOP" only
        lcd.refresh();
        distanceDanger();
    }
}

                                //safe to reverse car
void distanceSafe()         
{
    danger = 0;             
    caution = 0;
    safe = 1;               //>>>>>>>>>safe = green led light up in safe mode
    buzzer.beep(1000,1);
    wait(1);
    buzzer.nobeep();
}

                                //caution : reverse car carefuly
void distanceCaution()      
{
    danger = 0;
    caution = 1;           //>>>>>>caution = yellow led light up in caution mode
    safe = 0;
    buzzer.beep(1000,1);
    wait(0.4);
    buzzer.nobeep();
}

                                //danger : stop reverse car
void distanceDanger()       
{
    danger = 1;             //>>>>>>>danger = red led light up in danger mode
    caution = 0;
    safe = 0;
    buzzer.beep(1000,1);
    wait(0.2);
    buzzer.nobeep();
}


                                //INTERRUPT SERVICE ROUTINE
void buttonPressed() 
{
    buttonFlag = 1; //set flag
}

#endif
