/**
@file main.cpp

@brief Program implementation
@brief Functions are called here when needed
*/
#include "main.h"
                                    //main function
int main()
{
    PHY_PowerDown();                        //Ethernet Power Down
    lcd.init();                             // the LCD display is initiated first when switch is on
    welcomeText();
    lcd.clear();
    button.rise(&buttonPressed);            //event generated on rising edge
    
    /// distance is measured in this loop
    while (1) {
        lcdBrightness = potBrightness;      //to adjust brightness using potentiometer
        getDistance();
        readDistance();
        lcd.clear();
     /// buttonFlag is set back to 0   
    if (buttonFlag){                        //if flag is set = 1
        
        ///the value of displayReading is inverted
        displayReading = ~displayReading;   //if '~displayReading'(button is pushed again) value will not be dispayed 
        buttonFlag = 0;                     // reset button back to 0
        }
        
        ///if the condition is meet, value of distance will be displayed
    if (displayReading){                    //if 'displayReading'(button is pushed) value of distance is displayed
        int distance=sensor.getDistanceCm();
        char buffer[14];
        int length = sprintf(buffer,"D= %d cm",distance);
        if(length<=14)
        lcd.printString(buffer,7,1);
        lcd.drawRect(5,6,60,10,0);            //lcd.drawRect(76(x),0(y),7(w),48(h),1(type))>>>>box for distance value
        }
    }
}

