/**
header file for motor, edit later
EDIT THE PWM FOR BOTH MOTOR
motorInit()
*/
#ifndef MOTORSLAM_H
#define MOTORSLAM_H

//mbed libraries//
#include "mbed.h"

#define DEFAULT_PWM_PERIOD      (0.001)     // 1 KHz
#define DEFAULT_PWM_PULSEWIDTH  (0.50)      // 50% duty cycle

/** Interface created to control left and right motors of SLAM robot
 *  TB6612FNG is the motor driver(H-bridge,dual motor driver)
 */

class Motorslam {
    public:     //Any class can refer to the field or call the method in it        
        /** Create an interface to connect TB6612FNG with mbed LPC1768
         *  @param pwmLeft, PWM output from mbed is channelled to Left Motor to control speed
         *  @param leftIn1, DigitalOut1 pin of mbed set to HIGH(1) to move motor forward
         *  @param leftIn2, DigitalOut2 pin of mbed set to HIGH(1) to move motor backwards
         */
        Motorslam( PinName pinPwmLeft, PinName pinLeftIn1, PinName pinLeftIn2,
                   PinName pinPwmRight, PinName pinRightIn1, PinName pinRightIn2,
                   PinName pinNStby);
        
        /** Set the speed of the motor
        * 
        * @param speed The speed of the motor is normalised between -1.0 and 1.0
        */
        
        void init();
        void setPwmLeft(float fPeriod, float fPulsewidth);
        void setPwmLeftperiod(float fPeriod);
        void setPwmLeftpulsewidth(float fPulsewidth);
         
        void setPwmRight(float fPeriod, float fPulsewidth);
        void setPwmRightperiod(float fPeriod);
        void setPwmRightpulsewidth(float fPulsewidth);
         
        void standby(void);
         
        void motorLeft_stop(void);
        void motorLeft_cw(void);
        void motorLeft_ccw(void);
         
        void motorRight_stop(void);
        void motorRight_cw(void);
        void motorRight_ccw(void);
        
        void moveStop(void);
        void moveForward(void);
        void moveBackward(void);
        void moveLeft(void);
        void moveRight(void);
         
         
    private:
        PwmOut pwmLeft;
        DigitalOut leftIn1;
        DigitalOut leftIn2;
        PwmOut pwmRight;
        DigitalOut rightIn1;
        DigitalOut rightIn2;
        DigitalOut nStby;
        };
#endif

/**
 *       #include "mbed.h"
 *       #include "Motorslam.h"
 *
 *       TB6612FNG motor( p22, p5, p6,
 *                        p21, p7, p8,
 *                        p18 );
 *       float fPwmPeriod;
 *       float fPwmPulsewidth;
 *
 *       int main()
 *       {
 *           fPwmPeriod = 0.001f;        // 1KHz
 *           fPwmPulsewidth = 0.50;      // 50% duty cycle
 *           motor.setPwmLeftperiod(fPwmPeriod);
 *           motor.setPwmLeftpulsewidth(fPwmPulsewidth);
 *           motor.setPwmRightperiod(fPwmPeriod);
 *           motor.setPwmRightpulsewidth(fPwmPulsewidth);
 *   
 *           while(1)
 *           {
 *               motor.motorLeft_ccw();
 *               wait(2);
 *               motor.motorLeft_cw();
 *               wait(2);
 *               motor.motorLeft_stop();
 *               wait(2);
 *               motor.motorRight_ccw();
 *               wait(2);
 *               motor.motorRight_cw();
 *               wait(2);
 *               motor.motorRight_stop();
 *               wait(2);
 *           }
 *       }
*/

//OR//

/**
#include "mbed.h"
#include "Motorslam.h"

Motorslam motor( p22, p5, p6,
                 p21, p7, p8,
                 p18 );
float fPwmPeriod;
float fPwmPulsewidth;

void moveStop(void);
void moveForward(void);
void moveBackward(void);
void moveLeft(void);
void moveRight(void);

int main()
    {
        fPwmPeriod = 0.001f;        // 1KHz
        fPwmPulsewidth = 0.50;      // 50% duty cycle
        motor.setPwmLeftperiod(fPwmPeriod);
        motor.setPwmRightperiod(fPwmPeriod);
        motor.setPwmLeftpulsewidth(fPwmPulsewidth);
        motor.setPwmRightpulsewidth(fPwmPulsewidth);
     
        while(1)
        {
            moveForward();
            wait(2);
            moveBackward();
            wait(2);
            moveStop();
                }
                    }
                    
void moveStop(void)
{
    motor.standby();
    }
    
void moveForward(void)
{
    motor.motorLeft_cw();
    motor.motorRight_cw();
    }
    
void moveBackward(void)
{
    motor.motorLeft_ccw();
    motor.motorRight_ccw();
    }
void moveLeft(void)
{
    motor.motorLeft_ccw();
    motor.motorRight_cw();
    }
void moveRight(void)
{
    motor.motorLeft_cw();
    motor.motorRight_ccw();
    }
*/