//libraries//
#include "mbed.h"
#include "Motorslam.h"

#define SIG_HIGH    (1)
#define SIG_LOW     (0)

Motorslam::Motorslam(PinName pinPwmLeft, PinName pinLeftIn1, PinName pinLeftIn2,
                     PinName pinPwmRight, PinName pinRightIn1, PinName pinRightIn2,
                     PinName pinNStby):
                   
        pwmLeft(pinPwmLeft),
        leftIn1(pinLeftIn1),
        leftIn2(pinLeftIn2),
        pwmRight(pinPwmRight),
        rightIn1(pinRightIn1),
        rightIn2(pinRightIn2),  
        nStby(pinNStby)
        {
         leftIn1 = SIG_LOW;
         leftIn2 = SIG_LOW;
         rightIn1 = SIG_LOW;
         rightIn2 = SIG_LOW;
         nStby = SIG_LOW;
         pwmLeft.period(DEFAULT_PWM_PERIOD);
         pwmLeft = DEFAULT_PWM_PULSEWIDTH;
         pwmRight.period(DEFAULT_PWM_PERIOD);
         pwmLeft = DEFAULT_PWM_PULSEWIDTH;  
            }
        
        void Motorslam::init()
            {
         leftIn1 = SIG_LOW;
         leftIn2 = SIG_LOW;
         rightIn1 = SIG_LOW;
         rightIn2 = SIG_LOW;
         nStby = SIG_LOW;
         pwmLeft.period(DEFAULT_PWM_PERIOD);
         pwmLeft = DEFAULT_PWM_PULSEWIDTH;
         pwmRight.period(DEFAULT_PWM_PERIOD);
         pwmLeft = DEFAULT_PWM_PULSEWIDTH; 
                }
            
        void Motorslam::setPwmLeft(float fPeriod, float fPulsewidth)
        {
            pwmLeft.period(fPeriod);
            pwmLeft = fPulsewidth;
            }
            
        void Motorslam::setPwmLeftperiod(float fPeriod)
        {
            pwmLeft.period(fPeriod);
            }
            
        void Motorslam::setPwmLeftpulsewidth(float fPulsewidth)
        {
            pwmLeft = fPulsewidth;
            }
         
        void Motorslam::setPwmRight(float fPeriod, float fPulsewidth)
        {
            pwmRight.period(fPeriod);
            pwmRight = fPulsewidth;
            }
            
        void Motorslam::setPwmRightperiod(float fPeriod)
        {
            pwmRight.period(fPeriod);
            }
            
        void Motorslam::setPwmRightpulsewidth(float fPulsewidth)
        {
            pwmRight = fPulsewidth;
            }
         
        void Motorslam::standby(void)
        {
            nStby = SIG_LOW;
            }
         
        void Motorslam::motorLeft_stop(void)
        {
            leftIn1 = SIG_LOW;
            leftIn2 = SIG_LOW;
            }
            
        void Motorslam::motorLeft_cw(void)
        {
            leftIn1 = SIG_HIGH;
            leftIn2 = SIG_LOW;
            nStby = SIG_HIGH;
            }
        void Motorslam::motorLeft_ccw(void)
        {
            leftIn1 = SIG_LOW;
            leftIn2 = SIG_HIGH;
            nStby = SIG_HIGH;
            }
         
        void Motorslam::motorRight_stop(void)
        {
            rightIn1 = SIG_LOW;
            rightIn2 = SIG_LOW;
            }
        void Motorslam::motorRight_cw(void)
        {
            rightIn1 = SIG_HIGH;
            rightIn2 = SIG_LOW;
            nStby = SIG_HIGH;
            }
        void Motorslam::motorRight_ccw(void)
        {
            rightIn1 = SIG_LOW;
            rightIn2 = SIG_HIGH;
            nStby = SIG_HIGH;
            }
     
        void Motorslam::moveStop(void)
        {
           Motorslam::standby(); 
            }
        void Motorslam::moveForward(void)
        {
            Motorslam::motorLeft_cw();
            Motorslam::motorRight_cw();
            }
        void Motorslam::moveBackward(void)
        {
            Motorslam::motorLeft_ccw();
            Motorslam::motorRight_ccw();
            }
        void Motorslam::moveLeft(void)
        {
            Motorslam::motorLeft_ccw();
            Motorslam::motorRight_cw();
            wait(0.5);//trial; (0.5) for low friction(wooden floor); (0.7) for high friction
            Motorslam::moveStop();//trial
            }
        void Motorslam::moveRight(void)
        {
            Motorslam::motorLeft_cw();
            Motorslam::motorRight_ccw();
            wait(0.5);//trial; (0.5) for low friction(wooden floor); (0.7) for high friction
            Motorslam::moveStop();//trial
            }
            