#include "mbed.h"
#include "USBKeyboard.h"

DigitalOut Led1(LED1);
PwmOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);

InterruptIn Master(p10);
InterruptIn Pulses(p12);

Serial pc(USBTX, USBRX); 
USBKeyboard keyboard;

int Count = 0;

void eMaster1() {
    Count=0;
    Led1=0;
    Led3=0;
    Led2=0;
    Led4=0;
}

void eMaster0() {

}

void ePulse1() {

}

void ePulse0() {
    wait(0.1);
    Count++;
    
    Led1 = (Count & 1 ? 1 : 0);
    Led2 = (Count & 2 ? 1 : 0);
    Led3 = (Count & 4 ? 1 : 0);
    Led4 = (Count & 8 ? 1 : 0);
}

int main() {
    Master.rise(& eMaster1);
    Pulses.rise(& ePulse1);
    Master.fall(& eMaster0);
    Pulses.fall(& ePulse0);
    
    while(1)
    {
        if(Master==0 and Count>0)
        {
            if (Count == 10) Count=0;
            //pc.putc(Count+48);
            if (Count == 0) keyboard.sendKey('0'); 
            if (Count == 1) keyboard.sendKey('1'); 
            if (Count == 2) keyboard.sendKey('2');
            if (Count == 3) keyboard.sendKey('3');
            if (Count == 4) keyboard.sendKey('4');
            if (Count == 5) keyboard.sendKey('5');
            if (Count == 6) keyboard.sendKey('6');
            if (Count == 7) keyboard.sendKey('7');
            if (Count == 8) keyboard.sendKey('8');
            if (Count == 9) keyboard.sendKey('9');
            
            Led4= !Led4;
            Count=0;
        }
    }
}
