#ifndef _KS0070B_H
#define _KS0070B_H

#include "mbed.h"

// Editable defines. Common to all the drivers connected. Only the E signal will differ to address them individually.
#define PIN_RW p22
#define PIN_RS p23
#define PIN_D7 p28
#define PIN_D6 p27
#define PIN_D5 p26
#define PIN_D4 p25

class KS0070B;

class KS0070B
{
private:
    DigitalOut e;
public:
    KS0070B(PinName pin_e);
    KS0070B* print(const char *str);
    KS0070B* printnb(float nb, int left, int right);
    KS0070B* clear();
    KS0070B* pos(int line, int column);    
    
private:
    void send(unsigned char data, bool isinstruction);
};

// Special characters for the print() method :
// %d : divide
// %b : black pad
// %l : left arrow
// %r : right arrow
// %m : µ
// %p : pi
// %t : theta

#endif
