#include "mbed.h"
#include "KS0070B.h"

DigitalOut rw(PIN_RW), rs(PIN_RS);
BusInOut databus(PIN_D4, PIN_D5, PIN_D6, PIN_D7);

KS0070B::KS0070B(PinName pin_e) : e(pin_e)
{
    wait_ms(50);
    databus.input();
    rs=0;
    rw=1;

    send(0x20, true); // 4 bits
    send(0x28, true); // 4 bits, 2 lines, 5x7 dots
    send(0x0C, true); // display on, cursor on, blinking on
    send(0x01, true); // clear display
    send(0x06, true); // increase, not shifted
    send(0x02, true); // return home
}

void KS0070B::send(unsigned char data, bool isinstruction)
{
    bool busy=true;
    while(busy) {
        e=1;
        if(databus>>3==0) busy=false; // lcd is ready
        e=0;
        wait_us(4);
        e=1;
        wait_us(4);
        e=0;
        wait_us(4);
    }
    rs=!isinstruction;
    rw=0;
    databus.output();

    databus=data>>4; //MSB
    wait_us(1);
    e=1;
    wait_us(2);
    e=0;
    wait_us(2);
    databus=data; //LSB
    wait_us(1);
    e=1;
    wait_us(2);
    e=0;
    wait_us(2);
    databus.input();

    rs=0;
    rw=1;
}

KS0070B* KS0070B::print(const char *str)
{
    char temp;
    for(int i=0; i<100 && (temp=str[i])!='\0'; ++i) {
        if(temp<126) {
            if(temp!='%') {
                send(temp, false);
            } else {
                temp=str[++i];
                switch(temp) {
                    case 'd':
                        send(0xFD, false);
                        break;
                    case 'b':
                        send(0xFF, false);
                        break;
                    case 'l':
                        send(0x7E, false);
                        break;
                    case 'r':
                        send(0x7F, false);
                        break;
                    case 'm':
                        send(0xE4, false);
                        break;
                    case 'p':
                        send(0xF7, false);
                        break;
                    case 't':
                        send(0xF2, false);
                        break;
                    default:
                        send('%', false);
                        --i;
                        break;
                }
            }
        } else send(0xFF, false);
    }
    return this;
}

KS0070B* KS0070B::printnb(float nb, int left, int right) {
    char str[20];
    int p;
    if(left<0) left=0;
    sprintf(str, "%+f", nb);
    for(p=0; p<10 && str[p]!='.'; ++p);
    if(p>left+1) { // overflow
        str[1]='O';
        str[2]='F';
        for(int i=3; i<2+left+right; ++i) {
            str[i]=' ';
        }
    } else {
        p=1+left-p;
        for(int i=left+right+1; i>p; --i) {
            str[i]=str[i-p];
        }
        for(int i=p; i>0; --i) str[i]='0';
    }
    str[left+right+((right>0)?2:1)]='\0';
    print(str);
    
    delete str;
    return this;
}

KS0070B* KS0070B::clear() {
    send(0x01, true);
    send(0x02, true);
    return this;
}

KS0070B* KS0070B::pos(int line, int column) {
    if((line==0 || line==1) && (column>=0 && column<=15)) {
        send(0x80|(0x40*(line==1))|(column&0x0F), true);
    }
    return this;
}
