// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Servo.h"


uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin;

int mode = 0;
int enter = 0;
int menu = 0;
int temp = 70;

Timer t;

//DigitalIn prog(p5);
//DigitalIn onoff(p6);
//DigitalIn up(p7);
//DigitalIn down(p8);

DigitalOut progo(p9);
DigitalOut myled1(LED1);
DigitalOut onoffo(p10);
DigitalOut myled2(LED2);
DigitalOut upo(p11);
DigitalOut myled3(LED3);
DigitalOut downo(p12);
DigitalOut myled4(LED4);

AnalogIn ain(p20);

InterruptIn button1(p5);
InterruptIn button2(p6);
InterruptIn button3(p7);
InterruptIn button4(p8);

Servo myservo(p22);

//PinDetect button1(p5);
//PinDetect button2(p6);
//PinDetect button3(p7);
//PinDetect button4(p8);

void bisr1()
{
    myled1 = 1;
    if (mode < 1) {
        menu = menu++;
    } else if (mode < 2) {
        menu = menu++;
        if (temp > 70)
            temp = temp -5;
        else
            temp = 70;
    } else if (mode < 3) {
        menu = menu++;
    } else {
    }
}
void bisr2()
{
    myled2 = 1;
    if (mode < 1) {
        enter = 1 - enter;
    } else if (mode < 2) {
        enter = 1 - enter;
    } else if (mode < 3) {
        enter = 1 - enter;
    } else {
    }
}
void bisr3()
{
    myled3 = 1;
    if (mode < 1) {
        menu = menu--;
    } else if (mode < 2) {
        menu = menu--;
        if (temp < 212)
            temp = temp +5;
        else
            temp = 215;
    } else if (mode < 3) {
        menu = menu--;
    } else {
    }
}
void bisr4()
{
    myled4 =1;
    progo = !progo;
    if (mode < 1) {
    } else if (mode < 2) {
    } else if (mode < 3) {
    } else {
    }
}

float readain(int res)
{
    float boil = 1.0;
    float calib = 0.606;
    float tmp[res];
    for (int i = 0; i < res; i++) {
        tmp[i] = ((((ain.read()-calib)/(boil-calib))*142)+70);//ain.read();//((ain.read()-0.89)*1410+60);
    }
    float sum = 0;
    for (int i = 0; i < res; i++) {
        sum = sum + tmp[i];
    }
    return sum/res;
}

bool TimerDone(Timer &timerobj, float endTime)
{
    float timeNow = timerobj.read();
    //printf("The time taken was %f seconds\n", timeNow);

    if (timeNow >= endTime) {
        return true;
    } else {
        return false;
    }

}

int menumain()
{
    mode = 0;
    enter = 0;
    menu = 0;
    uLCD.printf("\n Welcome to your tea maker\n"); //Default Green on black text
    uLCD.printf("\n  Please choose an option: \n");
    uLCD.color(RED);
    while(1) {
        if (menu < 1) {
            uLCD.locate(3,7);
            uLCD.textbackground_color(BLUE);
            uLCD.printf("\n  Heat Water \n");
            uLCD.textbackground_color(BLACK);
            uLCD.printf("\n  Make a Tea \n");
        } else {
            uLCD.locate(3,7);
            uLCD.textbackground_color(BLACK);
            uLCD.printf("\n  Heat Water \n");
            uLCD.textbackground_color(BLUE);
            uLCD.printf("\n  Make a Tea \n");
        }
        if (enter)
            return menu;
    }
}

int menutwo(int response)
{
    mode = 1;
    enter = 0;
    menu = 0;
    uLCD.cls();
    uLCD.textbackground_color(BLACK);
    if (response < 1) {
        uLCD.locate(3,3);
        uLCD.printf("\n  Please choose a temperature: \n");
        uLCD.color(RED);
        float temporary = 0;
        while (1) {
            uLCD.locate(3,7);
            temporary = readain(5000);
            uLCD.printf("%d \n %f", temp, temporary);
            if (temporary < (temp - 7)) {
                progo = 1;
            } else if (temporary > (temp - 5)) {
                progo = 0;
            }
        }
    } else {
        uLCD.printf("\n  Please choose a tea type: \n");
        uLCD.color(RED);
        while(1) {
            if (menu < 1) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  White \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Yellow \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Green \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Red \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Black \n");
            } else if (menu < 2) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  White \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Yellow \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Green \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Red \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Black \n");
            } else if (menu < 3) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  White \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Yellow \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Green \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Red \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Black \n");
            } else if (menu < 4) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  White \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Yellow \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Green \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Red \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Black \n");
            } else {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  White \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Yellow \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Green \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Red \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Black \n");
            }
            if (enter)
                return menu;
        }
    }
}

int menuthree(int response)
{
    if (response == 2) {
        return menu;                            //170 2
    }
    mode = 2;
    enter = 0;
    menu = 0;
    uLCD.cls();
    uLCD.textbackground_color(BLACK);
    uLCD.printf("\n  Please choose a tea: \n");
    uLCD.color(RED);
    uLCD.locate(3,7);
    uLCD.textbackground_color(BLUE);
    if (response < 1) {
        uLCD.printf("  Bai Mudan \n");          //158, 4
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  WhitHairSilvNeed\n");    //167, 5
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Shoumei \n");            //180, 2
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Darjeeling \n");         //195, 3
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Other/Fruity \n");       //212, 5
        while(1) {
            if (menu < 1) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Bai Mudan \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  WhitHairSilvNeed\n");
            } else if (menu < 2) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Bai Mudan \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  WhitHairSilvNeed\n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Shoumei \n");
            } else if (menu < 3) {
                uLCD.locate(3,8);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  WhitHairSilvNeed\n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Shoumei \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Darjeeling \n");
            } else if (menu < 4) {
                uLCD.locate(3,9);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Shoumei \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Darjeeling \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Other/Fruity \n");
            } else {
                uLCD.locate(3,10);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Darjeeling \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Other/Fruity \n");
            }
            if (enter)
                return menu;
        }
    } else if (response < 2) {
        uLCD.printf("  Silver Needle \n");       //175 3
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Huoshan \n");             //180 2
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Other \n");               //170 3
        while(1) {
            if (menu < 1) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Silver Needle \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Huoshan \n");
            } else if (menu < 2) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Silver Needle \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Huoshan \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Other \n");
            } else if (menu < 3) {
                uLCD.locate(3,8);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Huoshan \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Other \n");
            }
            if (enter)
                return menu;
        }
    } else if (response < 4) {
        uLCD.printf("  Chinese \n");            //212 3
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Thai \n");               //212 5
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Rooibos \n");            //212 5
        uLCD.textbackground_color(BLACK);
        uLCD.printf("  Other \n");              //212 3
        while(1) {
            if (menu < 1) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Chinese \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Thai \n");
            } else if (menu < 2) {
                uLCD.locate(3,7);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Chinese \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Thai \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Rooibos \n");
            } else if (menu < 3) {
                uLCD.locate(3,8);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Thai \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Rooibos \n");
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Other \n");
            } else {
                uLCD.locate(3,9);
                uLCD.textbackground_color(BLACK);
                uLCD.printf("  Rooibos \n");
                uLCD.textbackground_color(BLUE);
                uLCD.printf("  Other \n");
            }
            if (enter)
                return menu;
        }
    } else {
        menu = 1;
        return menu;
    }
}

void maketea(int response, int action)
{
    int templ = 0;
    int time = 0;
    if (response == 2) {
        templ = 170;
        time = 2;
    } else if (response == 4) {
        templ = 212;
        time = 1;
    } else if (response == 3) {
        templ = 212;
        if (action == 0 || action == 3) {
            time = 3;
        } else {
            time = 5;
        }
    } else if (response == 1) {
        if (action == 0) {
            templ = 175;
            time = 3;
        } else if (action == 1) {
            templ = 180;
            time = 2;
        } else {
            templ = 170;
            time = 3;
        }
    } else {
        if (action == 0) {
            templ = 158;
            time = 1;
        } else if (action == 1) {
            templ = 167;
            time = 5;
        } else if (action == 2) {
            templ = 180;
            time = 2;
        } else if (action == 3) {
            templ = 195;
            time = 3;
        } else {
            templ = 212;
            time = 5;
        }
    }
    float temporary = 0;
    uLCD.cls();
    uLCD.printf("heating...");
    while (1) {
        temporary = readain(5000);
        uLCD.locate(3,1);
        uLCD.printf("heat to: %i \n current: %5.2f", templ, temporary);
        if (temporary < (templ - 7)) {
            progo = 1;
        } else if (temporary > (templ - 5)) {
            progo = 0;
            break;
        }
    }
    uLCD.cls();
    uLCD.printf("brewing... \n");
    for(int i = 180; i > 110; i--) {
        myservo = i/180.0;
        wait(0.05);
    }
    t.start();
    while(!TimerDone(t, time*60)) {
    }
    for(int i = 110; i < 180; i++) {
        myservo = i/180.0;
        wait(0.05);
    }
    uLCD.cls();
    uLCD.printf("Done...");
}

int main()
{
    wait(1);
    button1.mode( PullUp );
    button2.mode( PullUp );
    button3.mode( PullUp );
    button4.mode( PullUp );

//    button1.attach_deasserted(&bisr1);
//    button2.attach_deasserted(&bisr2);
//    button3.attach_deasserted(&bisr3);
//    button4.attach_deasserted(&bisr4);

    button1.rise(&bisr1);
    button2.rise(&bisr2);
    button3.rise(&bisr3);
    button4.rise(&bisr4);
    
    progo = 0;
    for(int i = 110; i < 180; i++) {
        myservo = i/180.0;
        wait(0.05);
    }
    wait(1);

    int response;
    response = menumain();
    response = menutwo(response);
    int action = menuthree(response);
    maketea(response, action);

    while(1) {
        //   progo = prog;
        myled1 = progo;
        //   onoffo = onoff;
        myled2 = onoffo;
        //   upo = up;
        myled3 = upo;
        //   downo = down;
        myled4 = downo;
       // uLCD.locate(3,3);
        //uLCD.printf("TxtLine %f \n and %f",ain.read(), abs(ain.read()-ain.read()));
    }

}