#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include <stdlib.h>

#define YELLOW 0xFFFF00
#define BROWN 0x964B00
#define GREN 0x228B22
#define RED 0xFF0000
#define BLUE 0x0000FF

#define pl1 1
#define pl2 2
#define w 3
#define slime 4
#define slime2 5
#define slime3 6
#define stc -1

uLCD_4DGL uLCD(p9,p10,p11);
Serial blue(p28,p27); // player 1
Serial toof(p13,p14); // player 2

Thread thread_clk;
Thread thread_input;
Thread thread_input2;
Thread ts;
//Thread thread_proc;

//InterruptIn Wbn(p21);
//InterruptIn Abn(p22);
//InterruptIn Sbn(p23);
//InterruptIn Dbn(p24);
//PinDetect Wbn(p21);
//PinDetect Abn(p22);
//PinDetect Sbn(p23);
//PinDetect Dbn(p24);

const int gb_SIZE = 14;

//current state of the game
int gameBoard[gb_SIZE][gb_SIZE];
//used to optimize draw function
int changeBoard[gb_SIZE][gb_SIZE];
//lock on both boards
Mutex boardM;

//displays if it's currently a clickable action or not
DigitalOut beat(LED1);

//counts up to 100
int counter;
//level in the game (for choosing bpm)
int level;
int kmrs;
int numPlayers;

int currAction; // 1 is W, 2 is A, 3 is S, 4 is D
int currAction2;
int actLock; // locks actions out after first action until next beat
int actLock2;
Mutex actM; // mutex on currAction

//method declarations
int levelTimes();
void clk();
void drawSquare(int i, int j, int temp);
void drawGB();
void processEnemyAction();

int p1x;
int p1y;
int stcx;
int stcy;

#define Bb 233.08

#define C  261.63

#define Cs 277.18

#define D  293.66

#define E  329.66

#define F  349.23

#define G  392.00

#define A  440.00

 int odd = 0;

PwmOut speaker(p26);

 

// the pin must be a PWM output pin

float note[64]= {293.66, 440.00, 329.66, 440.00, 349.23, 440.00, 392.00, 440.00,

                 349.23, 440.00, 329.66, 440.00, 293.66, 440.00, 277.18, 440.00,

                 293.66, 440.00, 329.66, 440.00, 349.23, 440.00, 392.00, 440.00,

                 349.23, 440.00, 329.66, 440.00, 293.66, 440.00, 277.18, 440.00,

                 233.08, 440.00, 261.63, 440.00, 293.66, 440.00, 329.66, 440.00,

                 349.23, 440.00, 329.66, 440.00, 293.66, 440.00, 261.63, 440.00,

                 261.63, 440.00, 293.66, 440.00, 329.66, 440.00, 349.23, 440.00,

                 392.00, 440.00, 349.23, 440.00, 329.66, 440.00, 293.66, 440.00

                };

 

void speaker_thread()

{
    while(1){
        for(int i = 0; i < 64; i++) {

        speaker.period(1.0/note[i]);

        speaker = 0.3;

        Thread::wait(1000);

    }}
    
}

// setup instance of new SongPlayer class, mySpeaker using pin 26


//returns the thread wait time for each level
int levelTimes() {
    if (level == 1) {
        return 10;
    } else if (level == 2) {
        return 10;
    }
    return 1000;
}


void clk() {
    // Game code waits for input on a timer
    beat = 1;
    // Have clock increment a counter from 0 upZ to 100 (wait time depends on song [level])
    for(;;) {
        Thread::wait(levelTimes());
        counter++;
        if (counter > 100) {
            counter = 1;
        }
        //reset ability to make action on half beat
        if (counter == 50) {
            processEnemyAction();
            actLock = 1;
            actLock2 = 1;
            //currAction = 0;
        }
        //indicate when a press is on beat. May need to alter according to calibration
        if (counter == 25 || counter == 75) {
            beat = !beat;
        }
    }
}

void processEnemyAction() {
    boardM.lock();
    for (int i = 0; i < gb_SIZE; i++) {
        for (int j = 0; j < gb_SIZE; j++) {
            if (gameBoard[i][j] == slime2 && changeBoard[i][j] != 1) { // enemy is here
                if (j > 0) {
                    if (gameBoard[i][(j - 1)] < 3) {
                        gameBoard[i][(j - 1)] = slime3;
                        changeBoard[i][(j - 1)] = 1;
                        gameBoard[i][j] = 0;
                        changeBoard[i][j] = 1;
                    }
                } else {
                    if (gameBoard[i][(gb_SIZE-1)] < 3) {
                        gameBoard[i][(gb_SIZE-1)] = slime3;
                        changeBoard[i][(gb_SIZE-1)] = 1;
                        gameBoard[i][j] = 0;
                        changeBoard[i][j] = 1;
                    }
                }
            }
        }
    }
    for (int i = 0; i < gb_SIZE; i++) {
        for (int j = 0; j < gb_SIZE; j++) {
            if (gameBoard[i][j] == slime3 && changeBoard[i][j] != 1) { // enemy is here
                if (j < gb_SIZE - 1) {
                    if (gameBoard[i][(j + 1)] < 3) {
                        gameBoard[i][(j + 1)] = slime2;
                        changeBoard[i][(j + 1)] = 1;
                        gameBoard[i][j] = 0;
                        changeBoard[i][j] = 1;
                    }
                } else {
                    if (gameBoard[i][(0)] < 3) {
                        gameBoard[i][(0)] = slime2;
                        changeBoard[i][(0)] = 1;
                        gameBoard[i][j] = 0;
                        changeBoard[i][j] = 1;
                    }
                }
            }
        }
    }
    odd++;
    if (odd % 4 == 0) {
        for (int i = 0; i < gb_SIZE; i++) {
            for (int j = 0; j < gb_SIZE; j++) {
                if (gameBoard[i][j] == 8 && changeBoard[i][j] != 1) { // enemy is here
                    if (p1x < i && gameBoard[i - 1][(j)] < 3) {
                        gameBoard[i - 1][(j)] = 8;
                        changeBoard[i - 1][(j)] = 1;
                        gameBoard[i][j] = slime;
                        changeBoard[i][j] = 1;
                    } else if (p1x > i && gameBoard[i + 1][(j)] < 3) {
                        gameBoard[i + 1][(j)] = 8;
                        changeBoard[i + 1][(j)] = 1;
                        gameBoard[i][j] = slime;
                        changeBoard[i][j] = 1;
                    } else if (p1y < j && gameBoard[i][(j - 1)] < 3) {
                        gameBoard[i][(j)-1] = 8;
                        changeBoard[i][(j-1)] = 1;
                        gameBoard[i][j] = slime;
                        changeBoard[i][j] = 1;
                    } else {
                        gameBoard[i][(j)+1] = 8;
                        changeBoard[i][(j+1)] = 1;
                        gameBoard[i][j] = slime;
                        changeBoard[i][j] = 1;
                    }
                }
            }
        }
    }    
    //draw board
    boardM.unlock();
}

void processAction() {
    // On timed update from T1, assess player action, then assess enemy actions (enemies not implemented)
        // Grab grid lock
        // Update grid backing game information based on player action
    boardM.lock();
    if (currAction != 0) {
        for (int i = 0; i < gb_SIZE; i++) {
            for (int j = 0; j < gb_SIZE; j++) {
                if (gameBoard[i][j] == pl1 && changeBoard[i][j] != 1) { // player is here
                    gameBoard[i][j] = 0;
                    changeBoard[i][j] = 1;
                    if (currAction == 1) {
                        if (j > 0) {
                            if (gameBoard[i][(j - 1)] < 1) {
                                gameBoard[i][(j - 1)] = pl1;
                                changeBoard[i][(j - 1)] = 1;
                                p1x = i;
                                p1y = j-1;
                            } else if (gameBoard[i][(j - 1)] == w) {
                                gameBoard[i][j] = 1;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        } else {
                            if (gameBoard[i][(gb_SIZE-1)] < 1) {
                                gameBoard[i][(gb_SIZE-1)] = pl1;
                                changeBoard[i][(gb_SIZE-1)] = 1;
                                p1x = i;
                                p1y = gb_SIZE -1;
                            } else if (gameBoard[i][(gb_SIZE-1)] == w) {
                                gameBoard[i][j] = 1;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        }
                    } else if (currAction == 2) {
                        if (i > 0) {
                            if (gameBoard[(i - 1)][j] < 1) {
                                gameBoard[(i - 1)][j] = pl1;
                                changeBoard[(i - 1)][j] = 1;
                                p1x = i-1;
                                p1y = j;
                            }else if (gameBoard[(i - 1)][j] == w) {
                                gameBoard[i][j] = 1;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        } else {
                            if (gameBoard[(gb_SIZE-1)][j]  < 1) {
                                gameBoard[(gb_SIZE-1)][j] = pl1;
                                changeBoard[(gb_SIZE-1)][j] = 1;
                                p1x = gb_SIZE - 1;
                                p1y = j;
                            }else if (gameBoard[(gb_SIZE-1)][j] == w) {
                                gameBoard[i][j] = 1;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        }
                    } else if (currAction == 3) {
                        if (gameBoard[i][(j+1)%gb_SIZE] < 1) {
                            gameBoard[i][(j+1)%gb_SIZE] = pl1;
                            p1x = i;
                            p1y = (j+1)%gb_SIZE;
                            changeBoard[i][(j+1)%gb_SIZE] = 1;
                        }else if (gameBoard[i][(j+1)%gb_SIZE] == w) {
                            gameBoard[i][j] = 1;
                            changeBoard[i][j] = 0;
                        } else {
                                level = -1;
                            }
                    } else if (currAction == 4) {
                        if (gameBoard[(i+1)%gb_SIZE][j]  < 1) {
                            gameBoard[(i+1)%gb_SIZE][j] = pl1;
                            changeBoard[(i+1)%gb_SIZE][j] = 1;
                            p1y = j;
                            p1x = (i+1)%gb_SIZE;
                        } else if (gameBoard[(i+1)%gb_SIZE][j] == w) {
                            gameBoard[i][j] = 1;
                            changeBoard[i][j] = 0;
                        } else {
                                level = -1;
                            }
                    } else if (currAction == 5) {
                        if (j > 0) {
                            if (gameBoard[i][(j - 1)] != w) {
                                gameBoard[i][(j - 1)] = 0;
                                changeBoard[i][(j - 1)] = 1;
                            }
                        } else {
                            if (gameBoard[i][(gb_SIZE-1)] != w) {
                                gameBoard[i][(gb_SIZE-1)] = 0;
                                changeBoard[i][(gb_SIZE-1)] = 1;
                            }
                        }
                        if (i > 0) {
                            if (gameBoard[(i - 1)][j] != w) {
                                gameBoard[(i - 1)][j] = 0;
                                changeBoard[(i - 1)][j] = 1;
                            }
                        } else {
                            if (gameBoard[(gb_SIZE-1)][j] != w) {
                                gameBoard[(gb_SIZE-1)][j] = 0;
                                changeBoard[(gb_SIZE-1)][j] = 1;
                            }
                        }
                        if (gameBoard[i][(j+1)%gb_SIZE] != w) {
                            gameBoard[i][(j+1)%gb_SIZE] = 0;
                            changeBoard[i][(j+1)%gb_SIZE] = 1;
                        }
                        if (gameBoard[(i+1)%gb_SIZE][j] != w) {
                            gameBoard[(i+1)%gb_SIZE][j] = 0;
                            changeBoard[(i+1)%gb_SIZE][j] = 1;
                        }
                        gameBoard[i][j] = 1;
                        changeBoard[i][j] = 0;
                    }
                }
            }
        }
    }
    processEnemyAction();
    if (gameBoard[p1x][p1y] != 1) {
        level = -1;
    }
    //draw board
    drawGB();
    //}
    boardM.unlock();

}

void processAction2() {
    // On timed update from T1, assess player action, then assess enemy actions (enemies not implemented)
        // Grab grid lock
        // Update grid backing game information based on player action
    boardM.lock();
    if (currAction2 != 0) {
        for (int i = 0; i < gb_SIZE; i++) {
            for (int j = 0; j < gb_SIZE; j++) {
                if (gameBoard[i][j] == pl2 && changeBoard[i][j] != 1) { // player is here
                    gameBoard[i][j] = 0;
                    changeBoard[i][j] = 1;
                    if (currAction2 == 1) {
                        if (j > 0) {
                            if (gameBoard[i][(j - 1)] < 1) {
                                gameBoard[i][(j - 1)] = pl2;
                                changeBoard[i][(j - 1)] = 1;
                                
                            } else if (gameBoard[i][(j - 1)] == w) {
                                gameBoard[i][j] = pl2;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        } else {
                            if (gameBoard[i][(gb_SIZE-1)] < 1) {
                                gameBoard[i][(gb_SIZE-1)] = pl2;
                                changeBoard[i][(gb_SIZE-1)] = 1;
                                
                            } else if (gameBoard[i][(gb_SIZE-1)] == w) {
                                gameBoard[i][j] = 1;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        }
                    } else if (currAction2 == 2) {
                        if (i > 0) {
                            if (gameBoard[(i - 1)][j] < 1) {
                                gameBoard[(i - 1)][j] = pl2;
                                changeBoard[(i - 1)][j] = 1;
                                
                            }else if (gameBoard[(i - 1)][j] == w) {
                                gameBoard[i][j] = 1;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        } else {
                            if (gameBoard[(gb_SIZE-1)][j]  < 1) {
                                gameBoard[(gb_SIZE-1)][j] = pl2;
                                changeBoard[(gb_SIZE-1)][j] = 1;
                               
                            }else if (gameBoard[(gb_SIZE-1)][j] == w) {
                                gameBoard[i][j] = pl2;
                                changeBoard[i][j] = 0;
                            } else {
                                level = -1;
                            }
                        }
                    } else if (currAction2 == 3) {
                        if (gameBoard[i][(j+1)%gb_SIZE] < 1) {
                            gameBoard[i][(j+1)%gb_SIZE] = pl2;
                            
                            changeBoard[i][(j+1)%gb_SIZE] = 1;
                        }else if (gameBoard[i][(j+1)%gb_SIZE] == w) {
                            gameBoard[i][j] = pl2;
                            changeBoard[i][j] = 0;
                        } else {
                                level = -1;
                            }
                    } else if (currAction2 == 4) {
                        if (gameBoard[(i+1)%gb_SIZE][j]  < 1) {
                            gameBoard[(i+1)%gb_SIZE][j] = pl2;
                            changeBoard[(i+1)%gb_SIZE][j] = 1;
                            p1y = j;
                            p1x = (i+1)%gb_SIZE;
                        } else if (gameBoard[(i+1)%gb_SIZE][j] == w) {
                            gameBoard[i][j] = 1;
                            changeBoard[i][j] = 0;
                        } else {
                                level = -1;
                            }
                    } else if (currAction2 == 5) {
                        if (j > 0) {
                            if (gameBoard[i][(j - 1)] != w) {
                                gameBoard[i][(j - 1)] = 0;
                                changeBoard[i][(j - 1)] = 1;
                            }
                        } else {
                            if (gameBoard[i][(gb_SIZE-1)] != w) {
                                gameBoard[i][(gb_SIZE-1)] = 0;
                                changeBoard[i][(gb_SIZE-1)] = 1;
                            }
                        }
                        if (i > 0) {
                            if (gameBoard[(i - 1)][j] != w) {
                                gameBoard[(i - 1)][j] = 0;
                                changeBoard[(i - 1)][j] = 1;
                            }
                        } else {
                            if (gameBoard[(gb_SIZE-1)][j] != w) {
                                gameBoard[(gb_SIZE-1)][j] = 0;
                                changeBoard[(gb_SIZE-1)][j] = 1;
                            }
                        }
                        if (gameBoard[i][(j+1)%gb_SIZE] != w) {
                            gameBoard[i][(j+1)%gb_SIZE] = 0;
                            changeBoard[i][(j+1)%gb_SIZE] = 1;
                        }
                        if (gameBoard[(i+1)%gb_SIZE][j] != w) {
                            gameBoard[(i+1)%gb_SIZE][j] = 0;
                            changeBoard[(i+1)%gb_SIZE][j] = 1;
                        }
                        gameBoard[i][j] = pl2;
                        changeBoard[i][j] = 0;
                    }
                }
            }
        }
    }
    //draw board
    drawGB();
    //}
    boardM.unlock();

}

void drawSquare(int i, int j, int temp) {
    if (temp == 0) { // empty
        if (level == 1) {
            uLCD.filled_rectangle(i * 9 + 1, j * 9 + 1, i * 9 + 8, j * 9 + 8, YELLOW);
        } else if (level == 2) {
            uLCD.filled_rectangle(i * 9 + 1, j * 9 + 1, i * 9 + 8, j * 9 + 8, 0x00FF00);
        }
    } else if (temp == pl1) { // player
//        uLCD.filled_rectangle(i * 9 + 3, j * 9 + 3, i * 9 + 6, j * 9 + 6, 0xFF0000);
        uLCD.filled_rectangle(i*9+2,j*9+6,i*9+3,j*9+7,RED);
        uLCD.filled_rectangle(i*9+6,j*9+6,i*9+7,j*9+7,RED);
        uLCD.line(i*9+3,j*9+5,i*9+3,j*9+2,RED);
        uLCD.line(i*9+7,j*9+5,i*9+7,j*9+2,RED);
        uLCD.line(i*9+3,j*9+2,i*9+8,j*9+2,RED);
    }  else if (temp == pl2) { // player
//        uLCD.filled_rectangle(i * 9 + 3, j * 9 + 3, i * 9 + 6, j * 9 + 6, 0xFF0000);
        uLCD.filled_rectangle(i*9+2,j*9+6,i*9+3,j*9+7,BLUE);
        uLCD.filled_rectangle(i*9+6,j*9+6,i*9+7,j*9+7,BLUE);
        uLCD.line(i*9+3,j*9+5,i*9+3,j*9+2,BLUE);
        uLCD.line(i*9+7,j*9+5,i*9+7,j*9+2,BLUE);
        uLCD.line(i*9+3,j*9+2,i*9+8,j*9+2,BLUE);
    } else if (temp == w) {
        uLCD.filled_rectangle(i * 9 + 2, j * 9 + 2, i * 9 + 7, j * 9 + 7, BROWN);
    } else if (temp == slime) {
        uLCD.filled_rectangle(i * 9 + 2, j * 9 + 2, i * 9 + 5, j * 9 + 5, RED);
        uLCD.filled_rectangle(i * 9 + 5, j * 9 + 5, i * 9 + 7, j * 9 + 7, RED);
    } else if (temp == slime2 || temp == slime3) {
        uLCD.filled_rectangle(i * 9 + 2, j * 9 + 2, i * 9 + 5, j * 9 + 5, GREN);
        uLCD.filled_rectangle(i * 9 + 5, j * 9 + 5, i * 9 + 7, j * 9 + 7, GREN);
    } else if (temp == stc) {
        uLCD.filled_rectangle(i*9 + 6, j * 9 + 1, i*9 + 7, j*9 + 7, 0);
        uLCD.filled_rectangle(i*9 + 4, j * 9 + 3, i*9 + 5, j*9 + 7, 0);
        uLCD.filled_rectangle(i*9 + 2, j * 9 + 5, i*9 + 3, j*9 + 7, 0);
    } else if (temp == 8) {
        uLCD.filled_rectangle(i*9 + 2, j * 9 + 2, i*9 + 2, j*9 + 7, 0xFFFFFF);
        uLCD.filled_rectangle(i*9 + 4, j * 9 + 2, i*9 + 4, j*9 + 7, 0xFFFFFF);
        uLCD.filled_rectangle(i*9 + 6, j * 9 + 2, i*9 + 6, j*9 + 7, 0xFFFFFF);
    }
}

void drawGB() {
    //draw all squares from gameboard which changeboard indicates are changed
    for (int i = 0; i < gb_SIZE; i++) {
        for (int j =0; j < gb_SIZE; j++) {
            if (changeBoard[i][j] > 0) {
                int temp = gameBoard[i][j];
                changeBoard[i][j] = 0;
                drawSquare(i, j, temp);
            }
        }
    }
}

void actionable(int i) {
    if (actLock) {
        actM.lock();
        actLock = 0;
        actM.unlock();
        if (counter <= 25 || counter >= 75) {
            currAction = i;
        } else {
            currAction = 0;
        }
        processAction();
    }
}

void actionable2(int i) {
    if (actLock2) {
        actLock2 = 0;
        if (counter <= 25 || counter >= 75) {
            currAction2 = i;
        } else {
            currAction2 = 0;
        }
        processAction2();
    }
}

void initLevel(int lvlNum) {
    for(int i = 0; i < gb_SIZE; i++) {
        for(int j = 0; j < gb_SIZE; j++) {
            gameBoard[i][j] = 0;
            changeBoard[i][j] = 0;
        }
    }
    if (lvlNum == 1) {
        p1x = 0;
        p1y = 0;
        stcx = 13;
        stcy = 13;
        gameBoard[13][13] = stc;
        changeBoard[13][13] = 1;
        gameBoard[0][0] = pl1;
        changeBoard[0][0] = 1;
        if (numPlayers > 1) {
            gameBoard[0][13] = pl2;
            changeBoard[0][13] = 1;
        }
        for (int bxm = 2; bxm < 9; bxm++) {
            gameBoard[1][bxm] = w;
            changeBoard[1][bxm] = 1;
        }
        for (int bxm = 11; bxm > 7; bxm--) {
            gameBoard[bxm][bxm] = w;
            changeBoard[bxm][bxm] = 1;
        }
        for (int bxm = 1; bxm < 5; bxm++) {
            gameBoard[bxm][2] = w;
            changeBoard[bxm][2] = 1;
        }
        for (int jqw =0; jqw< 7; jqw++) {
            int xxx = rand()%13 + 1;
            int yyy = rand()%14;
            gameBoard[xxx][yyy] = slime;
            changeBoard[xxx][yyy] = 1;
        }
        for (int jqw =0; jqw< 7; jqw++) {
            int xxx = rand()%13 + 1;
            int yyy = rand()%14;
            gameBoard[xxx][yyy] = slime2;
            changeBoard[xxx][yyy] = 1;
        }
    } else if (lvlNum == 2) {
        for(int i = 0; i < gb_SIZE; i++) {
            for(int j = 0; j < gb_SIZE; j++) {
                gameBoard[i][j] = 0;
                changeBoard[i][j] = 0;
            }
        }
        uLCD.background_color(0x00FF00);
        uLCD.cls();
        uLCD.color(BLACK);
        //display char # select menu TODO, Skipped for now
        //wait on input for char select TODO, Skipped for nowha
        //add calibration screen TODO, Skipped for now
        // draw board grid
        for (int i = 0; i < 128; i+=9) {
            uLCD.line(0, i, 127, i, 0);
            uLCD.line(i, 0, i, 127, 0);
        }
        p1x = 1;
        p1y = 1;
        stcx = 12;
        stcy = 12;
        for(int i = 0; i < gb_SIZE; i++) {
            for(int j = 0; j < gb_SIZE; j++) {
                gameBoard[i][j] = 0;
                changeBoard[i][j] = 0;
            }
        }
        gameBoard[12][12] = stc;
        changeBoard[12][12] = 1;
        gameBoard[1][1] = pl1;
        changeBoard[1][1] = 1;
        if (numPlayers > 1) {
            gameBoard[1][12] = pl2;
            changeBoard[1][12] = 1;
        }
        for (int i = 0; i < gb_SIZE; i++) {
            gameBoard[0][i] = w;
            gameBoard[i][0] = w;
            gameBoard[gb_SIZE - 1][i] = w;
            gameBoard[i][gb_SIZE - 1] = w;
            changeBoard[0][i] = 1;
            changeBoard[i][0] = 1;
            changeBoard[gb_SIZE - 1][i] = 1;
            changeBoard[i][gb_SIZE - 1] = 1;
        }
        gameBoard[7][7] = 8;
        changeBoard[7][7] = 1;
    } else {
        for(int i = 0; i < gb_SIZE; i++) {
            for(int j = 0; j < gb_SIZE; j++) {
                gameBoard[i][j] = 0;
                changeBoard[i][j] = 0;
            }
        }
//        uLCD.cls();
//        uLCD.color(GREN);
//        uLCD.printf("YOU WIN!!");
//        while(1);
    }
    drawGB();
}    

void inpizzy() {
    odd = 0;
    char bnum=0;
    char bhit=0;
    while(1) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                //add hit code here
                                actionable2(1);
                                //actionable(5);
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                actionable2(4);
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                actionable2(2);
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                actionable2(3);
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                actionable(1);
                            } else {
                                //add release code here
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                actionable(3);
                            } else {
                                
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                actionable(2);
                            } else {
                                //add release code here
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                actionable(4);
                            } else {
                                //add release code here
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}


int main()
{
    numPlayers = 0;
    level = 1;
    //initialize lcd
    uLCD.cls();
    uLCD.baudrate(3000000);
    uLCD.background_color(0xFFFF00);
    uLCD.cls();
    char bnum=0;
    char bhit=0;
    uLCD.text_width(1); //4X size text
    uLCD.text_height(1);
    uLCD.color(RED);
    uLCD.printf("How many Players?");
    while(numPlayers < 1) {
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    if (bnum=='1') {
                        numPlayers = 1;
                        //add hit code here
                    }
                    if (bnum=='2') {
                        numPlayers = 2;
                        //add hit code here
                    }
                }
            }
        }
    }
    uLCD.cls();
    uLCD.color(BLACK);
    //display char # select menu TODO, Skipped for now
    //wait on input for char select TODO, Skipped for nowha
    //add calibration screen TODO, Skipped for now
    // draw board grid
    for (int i = 0; i < 128; i+=9) {
        uLCD.line(0, i, 127, i, 0);
        uLCD.line(i, 0, i, 127, 0);
    }
    //initialize threads
    //initialize another thread if 2 chars TODO, Skipped for now
    

    //Andrew - initializing gameBoard to try to get a moving character demo
    initLevel(1);
    thread_clk.start(clk);
    thread_input.start(inpizzy);
    ts.start(speaker_thread);
    while(1) {
        if (p1x == stcx && p1y == stcy) {
            thread_clk.terminate();
            thread_input.terminate();
            ts.terminate();
            boardM.lock();
            level++;
            initLevel(level);
            boardM.unlock();
        }
        if (level == 2) {
            thread_clk.start(clk);
            thread_input.start(inpizzy);
            ts.start(speaker_thread);
            while(1) {
                if (p1x == stcx && p1y == stcy) {
                    wait(1);
                    thread_clk.terminate();
                    thread_input.terminate();
                    ts.terminate();
                    uLCD.background_color(0);
                    uLCD.cls();
                    uLCD.text_width(2); //4X size text
                    uLCD.text_height(2);
                    uLCD.color(GREN);
                    uLCD.printf("You WON");
                }
                if (level == -1) {
                    wait(1);
                    thread_clk.terminate();
                    thread_input.terminate();
                    ts.terminate();
                    boardM.lock();
                    uLCD.background_color(0);
                    uLCD.cls();
                    uLCD.text_width(2); //4X size text
                    uLCD.text_height(2);
                    uLCD.color(RED);
                    uLCD.printf("You Lost");
                    boardM.unlock();
                }
            }
        }
        if (level == -1) {
            wait(1);
            thread_clk.terminate();
            thread_input.terminate();
            ts.terminate();
            boardM.lock();
            uLCD.background_color(0);
            uLCD.cls();
            uLCD.text_width(2); //4X size text
            uLCD.text_height(2);
            uLCD.color(RED);
            uLCD.printf("You Lost");
            boardM.unlock();
        }
        
    }
    
    //play speaker TODO Not sure how
}
