#include "mbed.h"

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);
DigitalIn sw2(SW2);
DigitalIn sw3(SW3);
Serial pc(USBTX, USBRX);
AnalogOut my_output(DAC0_OUT);

char newFreq[3];
int Freq = 60;
//int bufferSize = 0;

#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)
#define STEP_US   (49)
#define FREQ_HZ   (60)
#define STEP      (0.00005)
#define BUFFER_SIZE ( (int) ( 1 / ( FREQ_HZ * STEP )))

int bufferSize = ( (int) ( 1 / ( Freq * STEP )));
int sw2_data = 0;

void calculate_sinewave(void);
void calculate_squarewave(void);
void calculate_triwave(void);
void check_sw2(void)
{
    if (sw2 == 0) {
        //sw2_data++;
        //pc.printf("SW2 button pressed. \n");
        if (sw2_data == 0) {
            led_green = 1;
            led_blue = 0;
            led_red = 1;
            calculate_triwave();
            pc.printf("TRIANGLE - Blue\n");
            sw2_data = 1;
            }
        else if (sw2_data == 1) {
            led_green = 1;
            led_blue = 1;
            led_red = 0;
            calculate_squarewave();
            pc.printf("SQUARE - Red\n");
            sw2_data = 2;
            }        
        else if (sw2_data == 2) {
            led_green = 0;
            led_blue = 1;
            led_red = 1;
            calculate_sinewave();
            pc.printf("SINE - Green\n");
            sw2_data = 0;
            }
        wait_us(1000000);
    }
}

void check_sw3(void)
{
    if (sw3 == 0) {
        //pc.printf("SW3 button pressed. \n");
        led_green = 1;
        led_red = 1;
        led_blue = 0;
        pc.printf("Enter a 3 digit frequency. Start typing. \n");
        for (uint32_t i = 0; i < 3; i++) {
            newFreq[i] = pc.putc(pc.getc());
        }
        pc.putc(13); /* CR */
        pc.putc(10); /* LF */
//        pc.printf("Freq: %s\n",newFreq);
        sscanf(newFreq, "%d", &Freq);
        pc.printf("Freq: %d Hz\n",Freq);
        bufferSize = ( (int) ( 1 / ( Freq * STEP )));
        pc.printf("Buffer: %d\n",bufferSize);
        uint16_t *buffer = new uint16_t[bufferSize];
        calculate_sinewave();
        sw2_data = 0;
    }
}

uint16_t *buffer = new uint16_t[bufferSize];

int main() {
    led_green = 1;
    led_red = 1;
    led_blue = 0;
    pc.baud(115200);
    pc.printf("\nNXP FRDM-K22F board.\n");
    pc.printf("Frequency Generator\n");
    pc.printf("Freq: %d Hz\n",FREQ_HZ);
    pc.printf("Buffer: %d\n",bufferSize);
    pc.printf("\n");
    calculate_sinewave();

    while(1) {              
        // sinewave output
        for (int i = 0; i < bufferSize; i++) {
            my_output.write_u16(buffer[i]);
            wait_us(STEP_US);
        }
        check_sw3();
        check_sw2();
    }
}

// Create the sinewave buffer
void calculate_sinewave(void){
  for (int i = 0; i < bufferSize; i++) {
     double rads = (PI * i)/(bufferSize / 2); // Convert degree in radian
     buffer[i] = (uint16_t)(AMPLITUDE * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}

// Create the squarewave buffer
void calculate_squarewave(void){
  for (int i = 0; i < (bufferSize / 2); i++) {
     buffer[i] = (uint16_t)(AMPLITUDE * (RANGE * (1)) + OFFSET);
  }
  for (int i = (bufferSize / 2); i < (bufferSize); i++) {
       buffer[i] = 0; //(uint16_t)(AMPLITUDE * (RANGE * (0.0)) + OFFSET);
  }
}

// Create the trianglewave buffer
void calculate_triwave(void){
  for (int i = 0; i < (bufferSize/2); i++) {
     double triPlus = (double) i / (bufferSize/2);
     double triMinus = (double) (1.0 - (triPlus));
     buffer[i] = (uint16_t)(AMPLITUDE * ((RANGE*2) * (triPlus)));
     buffer[(i + ((bufferSize / 2)))] = (uint16_t)(AMPLITUDE * ((RANGE*2) * (triMinus)));
     //pc.printf("Buffer: %E\n",triPlus);
     //pc.printf("Buffer: %E\n",triMinus);
  }
  buffer[bufferSize - 1] = 0;
}