#ifndef YELLOWMOTORS_H
#define YELLOWMOTORS_H

#define L_F 0x4
#define L_B 0x8
#define R_F 0x2
#define R_B 0x10

#include "mbed.h"
extern Serial pc;
// this is rather strange case, because my motors aren't performing both well. Left one has far weaker, causing delayed start-up and lower RPM. Thus my functions differ. I have a whole bigass spreadsheet of graphs and calculations by the way.
float motorLinearizationL(float);  // left motor is worse. at max desired speed it'll run at full 100% speed. this is thus weaker compensation.
float motorLinearizationR(float);  //  this is stronger compensation for more powerful motor. it runs it at < 100% speed

class YellowMotors // this class represents a shield. It's job is to control directions shift register and to forward received speed commands to aproprieate motors.
// The motors are objects of nested class MotorItself. The goal was to call methods directly on motors, but since they require different direcion regiter macros and linearizing functions, I made them to be private and accesible only through the parent YelloMotors object.
// It could that the motors get pointers to their linearization functions and macros at the initalization, but, meh, I'm not that passionate about C++.
{
private:
    DigitalOut *_led; // debug diode. lights up during shifting to register
    DigitalOut _clk;
    DigitalOut _lat;
    DigitalOut _dat;
    DigitalOut _ena; // OE active LOW
    char _directions;
    PinName Lpwm;
    PinName Rpwm;
    void _init();
    class MotorItself  // define a class for separate motors objects.
    {
    private:

    public:
        PwmOut _pwmPin;
        float _pwmSigned; // signed with direction
        int speed;  // to be done
        MotorItself() : _pwmPin(NC) {};
        MotorItself(PinName pwmPin): _pwmPin(pwmPin) {};  // fuck you, you default constructor.
        /*
        explicit MotorItself(float value): _pwmPin(D0) {  // _pwmPin(FUCKYOU) , pwm has no default constructor.. JEEEZ. that messes up the whole instance.
            this->_pwmSigned = value; // store this value;
            //_pwmPin = abs(value); // to be done: apply linearization
            pc.printf("explicit glupi/n/r");
        }
        */
        //operator float();
        void operator= (const float value) {
            this->_pwmSigned = value; // store this value;
            this->_pwmPin.write(value); // to be done: apply linearization
            //pc.printf("jestem w operatorze =. przypisuje %.2f. odczyt: %f\n\r", abs(value), _pwmPin.read());
        };
        bool operator== ( float value) {
            return abs(this->_pwmSigned) == value ;
        }
        //float operator= (const motorItself & toreturn) {
        //    return toreturn._pwmSigned; // return current desired speed with direction indication
        //};
    };
    MotorItself L, R;
public:
    YellowMotors(PinName clk = D4, PinName  lat = D12, PinName  dat = D8, PinName ena = D7, PinName Lpwm = D11, PinName Rpwm = D3);
    void setDirections(char); // shift directions to shift register on Adafruit motor shield v1
    void operator= (const float value);
    void set(float value, int whichMotor = -1);  // set speed of a motor. float. second parameter is which motor. L is 0 , R is 1 , -1 is both (default)
    float get(int whichMotor = -1); // get the value from the class, so you don't have to keep track of it by yourself
    void attachled(DigitalOut & led); // pass an initalized DigitalOut object for a library to use it as debuging LED
    void dettachled() {
        delete _led;
    } ;
};

#endif