/* This library lets to use a led display made of at most 8 segments as a screen buffer device. Like this one: https://www.dropbox.com/s/a3rvqahxhvpj0w3/general.jpg?dl=0
The dispaly has to be made of two shift registers - i used 4094 and they are guaranteed to work, but others may also without any change to the code. The 8 digits limit can be easily overcomed daisy-chaining more shift registers. Have in mind though that it will cause the dispaly to be dimmer.
This library lets you treat the display as a screen buffer device i.e. each digit is a byte-sized and bits are ordered as usual ABCDEFG scheme goes. Object has a field fb, which is the size you have it initialized.
Size 4 by default. So just write to object.fb[n] whatever you want. You can do all sorts of bitwise operations. And then you have to take care of calling the draw() method periodcaly to update the display. (preffered way: use systick or timer).
There is also provided function to convert most ASCII characters to bitmasked segments: digitORascii2char. It also allows to toggle a dot. Hope you like it.
There is a bonus feature: you can arrange the common cathodes/anodes in any way in the shift registers, because you can initialise the library with given order of them.
The same with segments. (in progress). Moreover there can be different layout of segments between each digit (also not done). Whoa!
*/
#include "mbed.h"

#ifndef LED7segmDual4094_h
#define LED7segmDual4094_h
	
class LED7segmDual4094{
	private:
		char _numOfSegments;
		unsigned int *_anodesBitMask;
		unsigned int _segmentsBitMask;
		bool _anodesActiveState;
		DigitalOut _data;
		DigitalOut _clock;
		DigitalOut _strobe;
		void send4094(unsigned short _load);
	public:
		LED7segmDual4094(PinName data, PinName clock, PinName strobe, char numOfSegments = 4);
		char *fb;
		void draw();
		void setAnodesBitMask(unsigned int *tab);
		void setAnodesActiveState(bool state);
//		void draw(char *tab);
		unsigned short load;
		//char i;
		char whichSegmMux;			
		signed char digitORascii2char(char input, bool dot=0);
//		signed char return7seg;
	
};
		
#endif