#ifndef JOYSTICK_H
#define JOYSTICK_H

#include <mbed.h>

class Joystick{
	private:
		class Button {
		    protected:		    
		        Callback<void()> _callback_rise;
		        Callback<void()> _callback_fall;
		    public:
	    	    InterruptIn     _irqpin;

		        enum Edge { RisingEdge = 0, FallingEdge };
		        
		        Button(PinName p, PinMode mode = PullUp) : _irqpin(p, mode) {
		            _irqpin.rise(callback(this, &Button::call_rise));
		            _irqpin.fall(callback(this, &Button::call_fall));
		        }
		        
		        void attach(Edge edge, Callback<void()> cb) { 
		            if (edge == RisingEdge) _callback_rise = cb ; 
		            else {                  _callback_fall = cb ; }
		        }
		 		 
		        void call_rise(void) { if (_callback_rise) _callback_rise.call(); }
		        void call_fall(void) { if (_callback_fall) _callback_fall.call(); }
		};

		Button _key_up;
		Button _key_down;
		Button _key_left;
		Button _key_right;
		Button _key_select;
	public:
		enum Action { Press = 0, Release };
		enum Direction { Up, Down, Left, Right, Select };
		
		Joystick(PinName key_up = PI_8,    \
				 PinName key_down = PI_10,  \
				 PinName key_left = PI_9,    \
				 PinName key_right = PF_11,   \
				 PinName key_select = PC_13) : \
		_key_up(key_up, PullDown), \
		_key_down(key_down, PullDown),\
		_key_left(key_left, PullDown),\
		_key_right(key_right, PullDown),\
		_key_select(key_select, PullDown)
		{
		}

        void attach(Direction direction, Action action, Callback<void()> cb) { 
        	Button * button;
        	switch(direction){
        		case Up:
        		button = &_key_up;
        		break;
        		case Down:
        		button = &_key_down;
        		break;
        		case Left:
        		button = &_key_left;
        		break;
        		case Right:
        		button = &_key_right;
        		break;
        		case Select:
        		button = &_key_select;
        		break;
        	}       	
            if (action == Press)    button->attach( Button::RisingEdge,  cb ); 
            else                    button->attach( Button::FallingEdge, cb ); 
        }
};

#endif