#include "mbed.h"

class GP2Y1010AU0F
{
public:
    GP2Y1010AU0F(PinName aout, PinName iled): _iled(iled), _aout(aout),  _aout_at_no_dust(0.7) {
    };

    void measure() {
        _measurement_ready = false;
        _measure();
    };

    bool getVoltage(float & value) {
        if (_measurement_ready == false) return NULL;
        else {
            float dust_density = 0;
            dust_density = ((float)_last_measurement)/(65535.0f/3.3f/9.25f);
            value = dust_density;
            return true;
        }
    }; // ug / m^3

    float convertVoltageToMg(float voltage) {
        voltage -= _aout_at_no_dust; // [V] from 0
        voltage /= _dust_sensitivity; // [0.1mg] == [100ug] / m^3
        voltage *= 100.0f;
        return voltage;
    }

    void tryTosetAoutAtNoDust(float newNoDustVoltage) {
        if (newNoDustVoltage < _aout_at_no_dust)
            _aout_at_no_dust = (newNoDustVoltage + 5*_aout_at_no_dust) / 6;
//        printf("Aout at no dust: %.3f\r\n", _aout_at_no_dust);
    }

    float getAoutAtNoDust() {
        return _aout_at_no_dust;
    }

private:
    AnalogIn _aout;
    DigitalOut _iled;
    Timeout _turnILEDOffTimeout;
    Timeout _sampleAOUTTimeout;
    Timeout _measurementReadyTimeout;
    unsigned short _last_measurement;
    bool _measurement_ready;
    static const float _dust_sensitivity = 0.5; // [V] / [mg/m^3]
    float _aout_at_no_dust; // [V] ?

    void _measure() {
        _sampleAOUTTimeout.attach(callback(this, &GP2Y1010AU0F::_sampleAOUT), .00028);
        _turnILEDOffTimeout.attach(callback(this, &GP2Y1010AU0F::_turnILEDOff), .00032);
        _measurementReadyTimeout.attach(callback(this, &GP2Y1010AU0F::_ready), .037);

        _turnILEDOn();
    };
    void _turnILEDOn() {
        _iled.write(1);
//    pc.printf("O");
    };
    void _turnILEDOff() {
        _iled.write(0);

//    pc.printf("C\r\n");
    };
    void _sampleAOUT() {
        _last_measurement = _aout.read_u16();
//    pc.printf("S");
    };
    void _ready() {
        _measurement_ready = true;
    };
};