#include "mbed.h"

#ifndef BH1750_h
#define BH1750_h

class BH1750
{
private:
    static const char ADDRESS_LOW = 0x23;
    static const char ADDRESS_HIGH = 0x5C;
    static const char powerOn_cmd = 0b00000001;
    static const char powerDown_cmd = 0b00000000;
    static const char reset_cmd = 0b00000111;

    static const char L_RES_MEASUREMENT_TIME = 12; // ms
    static const char H_RES_MEASUREMENT_TIME = 120; // ms

    char _address;
    char _currentMode;
    char _currentMtreg;
    unsigned int _waitForMeasurement;
    bool _autoModeAdjustSwitch;
    I2C &_i2c_inst;

    void _sendCommand(char);

    unsigned int _readRaw();
    bool _autoModeAdjust(float measurement); // returns if adjusted or left alone      
    float _readSingle();
public:
    static const char CONTINOUS_L_RES_CMD =  0b00010011;
    static const char CONTINOUS_H_RES_CMD =  0b00010000;
    static const char CONTINOUS_H2_RES_CMD = 0b00010001;
    static const char ONETIME_L_RES_CMD = 0b01000011;
    static const char ONETIME_H_RES_CMD = 0b01000000;
    static const char ONETIME_H2_RES_CMD = 0b01000001;
    static const char DEFAULTMTREG = 69;

    BH1750(I2C & , bool autoRange = false, bool addressPinState = false);
    void power(bool); // power on or off.
    float read();   // main function to read a value (or rather perform a read when in one_time mode)
    void setMode(const char); // set mode. datasheet lists L, H, H2 resolution modes in continous and one_time versions
    void setMtreg(char);    // correcting measurement time. can be used to increase precision by a factor of 3.86 at the cost of time
};

#endif