#include <stdio.h>
#include <string.h>
#include "mbed.h"

//Colours for printf
#define cyan "\033[0;36m" /* 0 -> normal; 36 -> cyan */
#define green "\033[4;32m" /*4 -> underline ; 32 -> green */
#define blue "\033[9;34m" /*9 -> strike ; 34 -> blue */
#define KWHT "\x1B[37m"
#define none "\033[0m" /* to flush the previous property */

//IO declarations
Serial pc(USBTX, USBRX); //PC UART
//DigitalOut led1(LED1);
DigitalOut GREEN(LED2); //Input Mode
DigitalOut BLUE(LED3); //output mode
DigitalIn sw2(SW2); //INPUT MODE SELECT
DigitalIn sw3(SW3); //Output mode select

//Bluetooth module declaration
Serial HC06(PTC15, PTC14); //BT TX, RX
char snd[512], rcv[1000]; //send and receive buffer

int main()
{

    GREEN=BLUE=1; //LEDs are off
    int mode=0; //Mode 0 for android-to-k64f, 1 for k64f-to-android
    int timer=0; //Timer for entering the default android-to-k64f

//default settings
    HC06.printf("Welcome to the ECE embedded lab\n"
                "This lab is intended to create a communication link between embedded system and android device over bluetooth");

    printf("%swelcome to the ece embedded lab\n"
           "This lab is intended to create a communication link between embedded system and android device over bluetooth"
           "please make sure that you have the application installed and running on your android device"
           "be sure that the bluetooth and location sensor is enabled\n\n\n", cyan);

    HC06.printf("Hold down SW2 (Blue LED) for 3 seconds to choose k64f-to-android mode or SW3(Green LED) FOR Android-to-k64\n");
    printf("%sHold down SW2 (Blue LED) for k64f-to-android mode or""SW3(Green LED) for Android-to-k64\n\n\n", KWHT);
    HC06.printf("The default mode (Android-to-K64f mode) will be selected automatically in 15 seconds\n");
    printf("%sThe default mode (android-to-k64f mode) will be selected automatically in 15 seconds\n\n\n", none);

    while(1) {
        wait(2);
        timer+=1;
        if (timer==8) break;

        if(!sw3) {
            HC06.printf("\nAndroid-to-k64 mode chosen\n");
            printf("\nAndroid-to-k64f mode chosen\n");
            GREEN=0;

            break;
        }
        if (!sw2) {
            BLUE=0;
            mode=1;
            HC06.printf("\nK64F-TO android mode chosen\n");
            printf("\nk64f-to-android mode chosen\n");

            break;
        }
    }

    while(1) {
        while(mode==0) {
            HC06.gets(rcv,1000);
            //HC06.scanf("%s",rcv);
            if (strstr(rcv,"mode=1")!=NULL) {
                mode=1;
                printf("Mode is changed to K64f-to-Android mode\n");
                puts(rcv);

            }
            while (mode==1) {
                pc.scanf("%s",snd);

//pc.gets(snd,510);

                if(strstr(snd,"mode=0")!=NULL) mode=0;
                {
                    mode=0;
                    printf("Mode is changed to Android-to-K64f mode\n");
                }
                pc.printf("%s sent\n",snd);
                HC06.printf("%s\n",snd);
            }

        }
    }
}
