#include "mbed.h"
#include "M2XStreamClient.h"
#include "EthernetInterface.h"

//Sonar 1 PinOuts
    DigitalOut trigger1(PTA1);
    DigitalOut trigger2(PTA2);

//Sonar 2 PinOuts
    DigitalIn  echo1(PTB9);
    DigitalIn  echo2(PTB23);

Timer sonar1, sonar2, loop_timer;

// Initialize Serial port
Serial pc(USBTX, USBRX);

// Set Sensor Stream details
char deviceId[] = "f2f53c114b0b1707ff849d387f173d17"; // Device you want to push to
char streamTrig_1[] = "Trigger_from_sensor_1"; // Stream you want to push to
char streamTrig_2[] = "Trigger_from_sensor_2"; // Stream you want to push to
char m2xKey[] = "9464d9e65f761bc5511bc085333a522b"; // Your M2X API Key or Master API Key

//Variable Declaration
int distance1_current = 0;
int distance1_previous = 0;
int correction1 = 0;

int distance2_current = 0;
int distance2_previous = 0;
int correction2 = 0;

int change_in_distance1;
int change_in_distance2;

int loop_time;

int sensitivity_threshold;

//function declaration
int sonar1_correction();
int sonar1_distance(int correction1);

int sonar2_correction();
int sonar2_distance(int correction1);

//Functions
int sonar1_distance(int correction1){
    trigger1 = 1;
    sonar1.reset();
    wait_us(10.0);
    trigger1 = 0;
        
    //wait for echo1 high
    while (echo1==0) {};
        
    //echo1 high, so start timer
    sonar1.start();
        
    //wait for echo1 low
    while (echo1==1) {};
    
    //stop timer and read value
    sonar1.stop();

    //subtract software overhead timer delay and scale to cm
    distance1_current = (sonar1.read_us()-correction1)/58.0;
    return distance1_current;
}

int sonar2_distance(int correction2){
    trigger2 = 1;
    sonar2.reset();
    wait_us(10.0);
    trigger2 = 0;
        
    //wait for echo1 high
    while (echo2==0) {};
        
    //echo1 high, so start timer
    sonar2.start();
        
    //wait for echo1 low
    while (echo2==1) {};
    
    //stop timer and read value
    sonar2.stop();

    //subtract software overhead timer delay and scale to cm
    distance2_current = (sonar2.read_us()-correction2)/58.0;
    return distance2_current;
}

int sonar1_correction(){
    // measure actual software polling timer delays FOR SONAR 1
    // delay used later in time correction1
    // start timer
    sonar1.start();
    
    // min software polling delay to read echo pin
    while (echo1==2) {};
    
    // stop timer
    sonar1.stop();
    
    // read timer
    correction1 = sonar1.read_us();
    
    //printf("Approximate software overhead timer delay is %d uS\n\r",correction1);
    return correction1;
}

int sonar2_correction(){
    // measure actual software polling timer delays FOR SONAR 1
    // delay used later in time correction1
    // start timer
    sonar2.start();
    
    // min software polling delay to read echo pin
    while (echo2==2) {};
    
    // stop timer
    sonar2.stop();
    
    // read timer
    correction2 = sonar2.read_us();
    return correction2;
}

int main()
{
        
    // Intialize Ethernet connection
        EthernetInterface eth;
        eth.init();
        eth.connect();
        printf("Success. Connected!. Device IP Address is %s\r\n", eth.getIPAddress());
        
    // Initialize the M2X client
        Client client;
        M2XStreamClient m2xClient(&client, m2xKey);
        int ret;

    
    correction1 = sonar1_correction();
    correction2 = sonar2_correction();

    // Initialize Sensors
        distance1_previous = sonar1_distance(correction1);
        distance2_previous = sonar2_distance(correction1);

    sensitivity_threshold = 15;
    
    while(1){
        
        loop_timer.reset();
        loop_timer.start();

        distance1_current = sonar1_distance(correction1);
        distance2_current = sonar2_distance(correction1);

        
        change_in_distance1=abs(distance1_current-distance1_previous);
        change_in_distance2=abs(distance2_current-distance2_previous);
        
        printf("correction1: %d , distance1: %d \n\r", correction1, distance1_current);
        printf("Change in distance for sensor 1 = %d\n\r", change_in_distance1);
        if(change_in_distance1 > sensitivity_threshold){
                printf("Sensor 1 is triggered.\n\r");
                printf("send() returned %d\r\n", ret);
                ret = m2xClient.updateStreamValue(deviceId, streamTrig_1, distance1_current);
                wait(2.0);
            }
        
            
        printf("correction2: %d , distance2: %d \n\r", correction2, distance2_current);
        printf("Change in distance for sensor 2 = %d\n\r", change_in_distance2);
            if(change_in_distance2 > sensitivity_threshold){
                printf("Sensor 2 is triggered.\n\r");
                printf("send() returned %d\r\n", ret);
                ret = m2xClient.updateStreamValue(deviceId, streamTrig_2, distance2_current);
                wait(2.0);
            }

        distance1_previous=distance1_current;
        distance2_previous=distance2_current;

        loop_timer.stop();
        loop_time=loop_timer.read_us();
        printf("Loop time = %d us\n\r", loop_time);
        printf("\n");
    }
      
}