#include "mbed.h"
#include "platform/mbed_thread.h"

//Pin Declaration
DigitalOut In1(D2); //Connection to In1 of L298N
DigitalOut In2(D3); //Connection to In2 of L298N
DigitalOut In3(D4); //Connection to In3 of L298N
DigitalOut In4(D5); //Connection to In4 of L298N
DigitalIn SW_Next_State(SW2); // Takes motor to next state, when SW2 is pushed.    PTC6 --> SW2
DigitalIn SW_Prev_State(SW3); // Takes motor to previous state, when SW2 is pushed.    PTA4 --> SW3
Serial BT(D1, D0); // Tx, Rx, Baudrate
AnalogIn LDR1 (PTB2); //Conntection for LDR1 for hand motion reading -->A0
AnalogIn LDR2 (PTB3); //Conntection for LDR2 for hand motion reading -->A1
AnalogIn LDR3 (PTB10); // Connection for daylight LDR -->A2


//Function Prototyping
int motor_state_zero();    //Initializes the digital output for L298N input pins
int motor_state_one();     //Sets L298N input pin configurations to state 1
int motor_state_two();     //Sets L298N input pin configurations to state 2
int motor_state_three();     //Sets L298N input pin configurations to state 3
int motor_state_four();     //Sets L298N input pin configurations to state 4
void RotateCW_1step();    //Rotates the stepper motor 1 step, clockwise
void RotateCCW_1step();    //Rotates the stepper motor 1 step, counter-clockwise
int Retrieve_BT_State(char);    //Gets the Bluetooth state in int data type
void check_handGesture();    //Retrieve hand gesture
void check_DayLight();    //Check daylight for automatic actuation

//Global Variable Declaration & Initialization
int motor_state=0;
int Desired_Pos=0;
int Current_Pos=1;
float wait_delay=0.05;    //wait for 0.05 seconds
char BT_state;
char BT_state_current;
char BT_AutoMode;
char AutomaticMode;
float ldr1_reading;
float ldr2_reading;
float ldr1_threshold=0.05;    //Threshold value of LDR1 in hand gesture module
float ldr2_threshold=0.05;    //Threshold value of LDR2 in hand gesture module
int LDR1_interrupted;
int LDR2_interrupted;

int main(){
    // Initialise the digital output for L298N input pins
    motor_state_zero();
    BT.printf("Reading data stream...\n\r");
    BT_state = 'z';
    BT_state_current;
    while (BT.readable()==0);

    while(true){
        while (BT.readable()) {
            
            BT_state_current = BT.putc(BT.getc());
            printf("inside readable. BT_state_current = %c    BT_state = %c\r\n",BT_state_current,BT_state);
            
            if (BT_state_current != BT_state){
                if((BT_state_current == 'x')||(BT_state_current == 'y')){
                    if(BT_state_current == 'y'){
                        AutomaticMode=1;
                    }
                }
                else{
                    printf("%c \r\n", BT_state_current);
                    BT_state = BT_state_current;
                    Desired_Pos = Retrieve_BT_State(BT_state);                 
                }
            }
        }
                        
                        
                        

        if (Current_Pos != Desired_Pos){
            
            printf("---> Desired Position = %d\r\n", Desired_Pos);
            printf("---> Current Position = %d\r\n", Current_Pos);
            
            while (Current_Pos > Desired_Pos){
                RotateCCW_1step();    //Rotate CCW 1 step
                Current_Pos -= 1;    //Decrement of Current_Pos by 1
                printf("Current Position = %d\r\n", Current_Pos);
            }
            
            while (Current_Pos < Desired_Pos){
                RotateCW_1step();    //Rotate CW 1 step
                Current_Pos += 1;    //Increment of Current_POS by 1
                printf("Current Position = %d\r\n", Current_Pos);
            }
        }
        
        if ((SW_Next_State != 1) && (Desired_Pos<26)){
            wait_ms(500);
            if ((SW_Prev_State != 1) && (SW_Next_State != 1)){
                printf("Initializing Current Position as Initial Position\r\n");
                Current_Pos = 1;    //Increment of Current_POS by 1
                Desired_Pos = 1;    //Increment of Current_POS by 1
                BT_state_current = '1';
                BT_state = '1';
                wait_ms(500);
            }
            else{
                RotateCW_1step();    //Use of on-board switch (SW2) to turn the stepper motor by one step, in the clockwise direction.
                Current_Pos += 1;    //Increment of Current_POS by 1
                Desired_Pos += 1;    //Increment of Current_POS by 1
                printf("---> Desired Position = %d\r\n", Desired_Pos);
                printf("---> Current Position = %d\r\n", Current_Pos);
                wait(wait_delay);
            }
        }
                
        if ((SW_Prev_State != 1) && (Desired_Pos>1)){
            wait_ms(500);
            if ((SW_Prev_State != 1) && (SW_Next_State != 1)){
                printf("Initializing Current Position as Initial Position\r\n");
                Current_Pos = 1;    //Increment of Current_POS by 1
                Desired_Pos = 1;    //Increment of Current_POS by 1
                BT_state_current = '1';
                BT_state = '1';
                wait_ms(500);
            }
            else{
                RotateCCW_1step();    //Use of on-board switch (SW3) to turn the stepper motor by one step, in the counterclockwise direction.
                Current_Pos -= 1;    //Increment of Current_POS by 1
                Desired_Pos -= 1;    //Increment of Current_POS by 1
                printf("---> Desired Position = %d\r\n", Desired_Pos);
                printf("---> Current Position = %d\r\n", Current_Pos);
                wait(wait_delay);
            }
        }
        
        if ((SW_Prev_State != 1) && (SW_Next_State != 1)){
                printf("Initializing Current Position as Initial Position\r\n");
                Current_Pos = 1;    //Increment of Current_POS by 1
                Desired_Pos = 1;    //Increment of Current_POS by 1
                BT_state_current = '1';
                BT_state = '1';
                wait_ms(500);
        }
        
        check_handGesture();

        if (AutomaticMode==1){
            printf("Automatic mode ON\r\n");
            while(true){
                while (BT.readable()){
                    BT_AutoMode = BT.putc(BT.getc());
                }
                
                check_DayLight();
                
                if(BT_AutoMode == 'x'){
                    printf("Automatic mode OFF\r\n");
                    AutomaticMode=0;
                    BT_AutoMode='y';
                    break;
                }
            }
        }
    }
}


//FUNCTION DEFINITION
int motor_state_zero(){
    In1=0;
    In2=0;
    In3=0;
    In4=0;
    motor_state=0;
    //printf("motor_state = %d\r\n",motor_state);
    return motor_state;
}

int motor_state_one(){
    In1=1;
    In2=0;
    In3=0;
    In4=0;
    motor_state=1;
    //printf("motor_state = %d\r\n",motor_state);
    return motor_state;
}

int motor_state_two(){
    In1=0;
    In2=0;
    In3=1;
    In4=0;
    motor_state=2;
    //printf("motor_state = %d\r\n",motor_state);
    return motor_state;
}

int motor_state_three(){
    In1=0;
    In2=1;
    In3=0;
    In4=0;
    motor_state=3;
    //printf("motor_state = %d\r\n",motor_state);
    return motor_state;
}

int motor_state_four(){
    In1=0;
    In2=0;
    In3=0;
    In4=1;
    motor_state=4;
    //printf("motor_state = %d\r\n",motor_state);
    return motor_state;
}

void RotateCW_1step(){
    printf("Rotating Clockwise 1 step\r\n");
    if (motor_state==0){
        motor_state_one();
        wait(wait_delay);
    }
    else if (motor_state==1){
        motor_state_two();
        wait(wait_delay);
    }
    else if (motor_state==2){
        motor_state_three();
        wait(wait_delay);
    }
    else if (motor_state==3){
        motor_state_four();
        wait(wait_delay);
    }
    else if (motor_state==4){
        motor_state_one();
        wait(wait_delay);
    }
}

void RotateCCW_1step(){
    printf("Rotating CounterClockwise 1 step\r\n");
    if (motor_state==0){
        motor_state_four();
        wait(wait_delay);
    }
    else if (motor_state==1){
        motor_state_four();
        wait(wait_delay);
    }
    else if (motor_state==2){
        motor_state_one();
        wait(wait_delay);
    }
    else if (motor_state==3){
        motor_state_two();
        wait(wait_delay);
    }
    else if (motor_state==4){
        motor_state_three();
        wait(wait_delay);
    }
}

int Retrieve_BT_State(char BT_state){
            if (BT_state == '0'){
                Desired_Pos = 0;
            }
            else if (BT_state == '1'){
                Desired_Pos = 1;
            }
            else if (BT_state == '2'){
                Desired_Pos = 2;
            }
            else if (BT_state == '3'){
                Desired_Pos = 3;
            }
            else if (BT_state == '4'){
                Desired_Pos = 4;
            }
            else if (BT_state == '5'){
                Desired_Pos = 5;
            }
            else if (BT_state == '6'){
                Desired_Pos = 6;
            }
            else if (BT_state == '7'){
                Desired_Pos = 7;
            }
            else if (BT_state == '8'){
                Desired_Pos = 8;
            }
            else if (BT_state == '9'){
                Desired_Pos = 9;
            }
            else if (BT_state == 'a'){
                Desired_Pos = 10;
            }
            else if (BT_state == 'b'){
                Desired_Pos = 11;
            }
            else if (BT_state == 'c'){
                Desired_Pos = 12;
            }
            else if (BT_state == 'd'){
                Desired_Pos = 13;
            }
            else if (BT_state == 'e'){
                Desired_Pos = 14;
            } 
            else if (BT_state == 'f'){
                Desired_Pos = 15;
            } 
            else if (BT_state == 'g'){
                Desired_Pos = 16;
            } 
            else if (BT_state == 'h'){
                Desired_Pos = 17;
            } 
            else if (BT_state == 'i'){
                Desired_Pos = 18;
            } 
            else if (BT_state == 'j'){
                Desired_Pos = 19;
            } 
            else if (BT_state == 'k'){
                Desired_Pos = 20;
            } 
            else if (BT_state == 'l'){
                Desired_Pos = 21;
            } 
            else if (BT_state == 'm'){
                Desired_Pos = 22;
            } 
            else if (BT_state == 'n'){
                Desired_Pos = 23;
            } 
            else if (BT_state == 'o'){
                Desired_Pos = 24;
            } 
            else if (BT_state == 'p'){
                Desired_Pos = 25;
            } 
            else if (BT_state == 'q'){
                Desired_Pos = 26;
            } 
            
            return Desired_Pos;
}

void check_handGesture(){

    int i,loop_time;

    Timer loop;
    ldr1_reading= LDR1;
    ldr2_reading= LDR2;

    if (ldr1_reading < ldr1_threshold){
        if (Current_Pos<26){
            if(ldr2_reading > ldr2_threshold){
                for(i=0;i<50;i++){
                    wait_ms(10);
                    ldr2_reading= LDR2;
                    //printf("LDR1 = %f    LDR2 = %f\n\r",ldr1_reading,ldr2_reading);
                    if(ldr2_reading < ldr2_threshold){
                        if (Current_Pos<13){
                            Desired_Pos=13;
                            BT_state='d';
                        }
                        else if(Current_Pos>=13){
                            Desired_Pos=26;
                            BT_state='q';
                        }
                        i=0;
                        break;
                    }
                }
            }
        }
        else{
            printf("Motor in Position 26. No More Clockwise Rotation... \r\n");
        }
        wait_ms(500);
    }

    if (ldr2_reading < ldr2_threshold){
        if (Current_Pos>1){
            if(ldr1_reading > ldr1_threshold){
                for(i=0;i<50;i++){
                    wait_ms(10);
                    ldr1_reading= LDR1;
                    if(ldr1_reading < ldr1_threshold){
                        if (Current_Pos>13){
                            Desired_Pos=13;
                            BT_state='d';
                        }
                        else if(Current_Pos<=13){
                            Desired_Pos=1;
                            BT_state='1';
                        }
                        i=0;
                        break;
                    }
                }
            }
        }
        else{
            printf("Motor in Position 1. No More Counter-Clockwise Rotation... \r\n");
        }
        wait_ms(500);
    }
}

void check_DayLight(){
    static float LDR_daylightThreshold = 0.15;
    static float LDR_daylightReading;
    LDR_daylightReading = LDR3;

    //printf("LDR_daylightReading = %f\r\n", LDR_daylightReading);
    
    if (LDR_daylightReading<LDR_daylightThreshold){ //it's night/dark
        Desired_Pos=1; //close flap get state 1
        BT_state='1';
        
    }
    if (LDR_daylightReading>LDR_daylightThreshold){ //it's day
        Desired_Pos=13; //open flaps get state 13
        BT_state='d';
    }
    
    if (Current_Pos != Desired_Pos){
            
            printf("---> Desired Position = %d\r\n", Desired_Pos);
            printf("---> Current Position = %d\r\n", Current_Pos);
            
            while (Current_Pos > Desired_Pos){
                RotateCCW_1step();    //Rotate CCW 1 step
                Current_Pos -= 1;    //Decrement of Current_Pos by 1
                printf("Current Position = %d\r\n", Current_Pos);
            }
            
            while (Current_Pos < Desired_Pos){
                RotateCW_1step();    //Rotate CW 1 step
                Current_Pos += 1;    //Increment of Current_POS by 1
                printf("Current Position = %d\r\n", Current_Pos);
            }
        }
    
}