

#include "GUI.h"

/*********************************************************************
*
*       Hardware configuration
*
**********************************************************************
*/



#define LCD_REG16  (*((volatile U16 *)(0x6F000000)))  /* RS = 0 */
#define LCD_DAT16  (*((volatile U16 *)(0x6F010000)))  /* RS = 1 */

/*********************************************************************
*
*       Exported code
*
*********************************************************************
*/
/*********************************************************************
*
*       LCD_X_Init
*
* Purpose:
*   This routine should be called from your application program
*   to set port pins to their initial values
*/
void LCD_X_Init(void) {
	
}


/*********************************************************************
*
*       LCD_X_WriteIndex
*
* 
*   
*/
void LCD_X_WriteIndex(U16 c) {
  LCD_REG16 = c;
}


/*********************************************************************
*
*       LCD_X_WriteData
*
* 
* 
*/
void LCD_X_WriteData(U16 c) {
  LCD_DAT16 = c;
}


/*********************************************************************
*
*       LCD_X_ReadData
*
* Purpose:
*   Read from controller, with A0 = 1
*/
U16 LCD_X_ReadData(void) {
  return (LCD_DAT16);
}

/*********************************************************************
*
*       LCD_X_WriteMData
*
* 
*   
*/
void LCD_X_WriteMData(U16 * pData, int NumWords) {
  for (; NumWords; NumWords--) {
    LCD_DAT16 = *pData++;
  }
}

/*********************************************************************
*
*       LCD_X_ReadM01_16
*
* Purpose:
*   Read multiple bytes from controller, with A0 = 1
*/
void LCD_X_ReadMData(U16 * pData, int NumWords) {
  for (; NumWords; NumWords--) {
    *pData++ = LCD_DAT16;
  }
}

/*************************** End of file ****************************/
