// Example

#include <string>

#include "mbed.h"
#include "eeprom.h"

#define EEPROM_ADDR 0x0   // I2c EEPROM address is 0x00

#define SDA I2C_SDA          // I2C SDA pin
#define SCL I2C_SCL           // I2C SCL pin

#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))









int main() 
{
    printf("%dHz\r\n" ,SystemCoreClock);
    
    uint8_t data[12] = {'A','m','m','a','r',' ','M','a','y','0','0','0'};
    uint8_t data_read[2048];
    int8_t r;
    
    EEPROM ep(SDA, SCL, EEPROM_ADDR,EEPROM::T24C16);
    
    //ep.clear();
    
    ep.write(0, data, 12);
    //ep.write(3, 7);
    
    
    
    ep.read(0, data_read, 2048);
    
    for (int i=0; i<2048; i++)
    {
        printf("EEPROM READ %X \r\n", data_read[i]);
        printf("\r\n");
    }
    
    ep.read(3, r);
    
    printf("EEPROM READ r %X \r\n", r);
    
    while(1) {
        
        
        wait(4);
        
        printf("------------------------------------ \r\n");
        printf("hello world \r\n");
    }
  
    
  
}
