#include "mbed.h"
#include "MMA8451Q.h"
#include "TextLCD.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
float acx=0,acy=0,acz=0;

int main(void) {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
    lcd.printf("Acelerometro");
    wait(2);
    lcd.locate(0,0);
    lcd.printf("acx=0   acy=0");
    lcd.locate(0,1);
    lcd.printf("acz=0   ");
    while (true) {
        rled = 1.0 - abs(acc.getAccX());
        acx=1.0 - abs(acc.getAccX());
        gled = 1.0 - abs(acc.getAccY());
        acy=1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());
        acz=1.0 - abs(acc.getAccZ());
        
        lcd.locate(4,0);
        lcd.printf("    ");
        lcd.locate(4,0);
        lcd.printf("%1.2f",acx);
        lcd.locate(12,0);
        lcd.printf("    ");
        lcd.locate(12,0);
        lcd.printf("%1.2f",acy);
        lcd.locate(4,1);
        lcd.printf("     ");
        lcd.locate(4,1);
        lcd.printf("%1.2f",acz);
         wait(0.2);
    }
}
