#include "mbed.h"
extern "C" {
#include "fx.h"
}

#include <time.h>
void sleepcp(int milliseconds);

void sleepcp(int milliseconds) // Cross-platform sleep function
{
    clock_t time_end;
    time_end = clock() + milliseconds * CLOCKS_PER_SEC/1000;
    while (clock() < time_end) {
    }
}


//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

int main()
{

    int Repetitions = 10000;
    int FxToCall = 100;

    float x[20];
    int count = 0;

    while(1) {
        pc.printf("Starting %d repetitions\r\n",Repetitions);

        clock_t start, end;
        double cpu_time_used;
        start = clock();
        count = 0;

        for (int r=0; r<Repetitions; r++) {
            for(int i=0; i<FxToCall; i++) {
                count += fxList[i](x);
            }
        }

        end = clock();
        long double diff = end-start;
        cpu_time_used = diff / ((long double)CLOCKS_PER_SEC / 1000.0);
        pc.printf("Elapsed time ms: %f\r\n",cpu_time_used);
        pc.printf("Elapsed time (ms) x repetition: %f\r\n",cpu_time_used/Repetitions);


    }
}
