#include "Led_Lcd.h"

#include "LCD_DISCO_F429ZI.h"
LCD_DISCO_F429ZI lcd;

LedLcd::LedLcd(unsigned char x){
    lcd.Clear(LCD_COLOR_BLACK);
    LEDXPOS = x*80;
    
}    

void LedLcd::On(unsigned char ucLedIndex){
    
    lcd.SetTextColor(LCD_COLOR_BLUE);
    lcd.FillRect(LEDXPOS, 0, 80, 320);
    
    lcd.SetTextColor(LCD_COLOR_YELLOW);
    lcd.FillRect(LEDXPOS, ucLedIndex*80, 79, 79);
    
    
    BSP_LCD_SetFont(&Font24);
    unsigned char ucButtonNumber[1];
    for(ucLedIndex = 0; ucLedIndex < 4; ucLedIndex++){
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf((char*)ucButtonNumber, "%d", ucLedIndex);
        lcd.DisplayStringAt(LEDXPOS, ucLedIndex*80, (uint8_t *) ucButtonNumber, LEFT_MODE);
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(LEDXPOS, ucLedIndex*80, 79, 79);
    }
        

    
}
