#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Speaker.h"
#include <vector>
#include <string>

//Set up LEDs
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

using namespace std;

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL uLCD(p9,p10,p11);
DigitalIn sdDetect(p17); // Set up a pin for SD Card Detect

PinDetect pb1(p21); // pb forup shift
PinDetect pb2(p22); // pb fordown shift
PinDetect pb3(p23); // pb for pause




AnalogOut DACout(p18); //set up speaker
wave_player waver(&DACout); //set up wave player library
int pos = 0; // index of the song
int vol = 0;

 
bool playing = false; //variable for pause/play since we only have 1 pb for that
vector<string> filenames; //filenames are stored in a vector string
void read_file_names(char *dir) // function that reads in file names from sd cards
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}
//interrupt handler for pb1 
void pb1_hit_callback (void)
{
    // it checks for the total number of songs in the sd card..then increments the index until it reaches the last one, then resets to 0
    int l = filenames.size();
    if (pos < (l-1)) {
        pos++;
    } else if (pos == (l-1)) {
        pos = 0;
    }
    string songname = filenames[pos];
    unsigned index = songname.find(".wav");
    songname = songname.substr(0,index);
    uLCD.cls();
    uLCD.printf(songname.c_str()); //it clears screen and then sets the new index song in the uLCD display
}
//interrupt handler for pb2
void pb2_hit_callback (void)
{
    //does opposite of pb1..moves the index down..from 2nd song to 1st song via changing the index number and then calling in the vector
    int l = filenames.size();
    if (pos > 0) {
        pos--;
    } else if (pos == 0 ) {
        pos = l-1;
    }
    string songname = filenames[pos];
    unsigned index = songname.find(".wav");
    songname = songname.substr(0,index);
    uLCD.cls();
    uLCD.printf(songname.c_str());
}
//interrupt handler for 3rd pushbutton
void pb3_hit_callback (void)
{
    //this interrupt handler changes the play to pause mode or vice versa
    //this is done using the boolean playing
    if (playing == false) {
        playing = true; 
    } else if (playing == true) {
        uLCD.cls();
        playing = false; 
        string songname = filenames[pos];
        unsigned index = songname.find(".wav");
        songname = songname.substr(0,index);
        uLCD.printf(songname.c_str());
    }
}


int main()
{
    sdDetect.mode(PullUp);
     wait(.1);
     //wait after pulling up the sd card, 
    // read file names into vector of strings
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    //pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    
    uLCD.cls();
    //detects whethere there is a SD card or not.. if not then it prints and informs the user
    while(sdDetect ==0) {
        uLCD.locate(0,0);
        uLCD.printf("Insert SD Card");
        wait(.5);
    }    
    uLCD.cls(); 
    wait(.5);
    sd.disk_initialize();
    read_file_names("/sd/");
    while(1) {
        //while pb3 is low, then we can start playing the song
        while(playing == true) { //we have 2 while loops..one while loop makes sure the music player is always on, the other one is for the song
            string songname = filenames[pos];
            string a = "/sd/";
            string fname = a + songname; //retrieves the file name
            FILE *wave_file; 
            uLCD.locate(0,4);
            uLCD.printf("Now Playing");
            wave_file = fopen(fname.c_str(),"r"); //opens the music file
            waver.play(wave_file); //plays the music file
            fclose(wave_file);
        }
    }
}
