#ifndef     _GAMEDUINO2_H_
#define     _GAMEDUINO2_H_

#include "mbed.h"
#include "arduino.h"
#include "GDTransport.h"

#define PROTO         1
#define STORAGE       1
#define CALIBRATION   0
#define DUMP_INPUTS   0
#define VERBOSE       0

#define RGB(r, g, b)    ((uint32_t)((((r) & 0xffL) << 16) | (((g) & 0xffL) << 8) | ((b) & 0xffL)))
#define F8(x)           (int((x) * 256L))
#define F16(x)          ((int32_t)((x) * 65536L))

#define GD_CALIBRATE    1
#define GD_TRIM         2
#define GD_STORAGE      4

#define REG_TRIM        0x10256C
#define LOW_FREQ_BOUND  47040000UL

class sdcard;

class GDClass
{
public:
    GDClass(PinName mosi, PinName miso, PinName sclk, PinName graphic_cs, PinName sdcard_cs);

    GDTransport GDTR;
    sdcard *SD;
    AnalogIn *accel[3];
    PinName _sdcard_cs;

    sdcard* getSD() { return SD; }
    void begin(unsigned char options = (GD_CALIBRATE | GD_TRIM | GD_STORAGE));

    unsigned short random();
    unsigned short random(unsigned short n);
    void seed(unsigned short n);
    short rsin(short r, unsigned short th);
    short rcos(short r, unsigned short th);
    void polar(int &x, int &y, short r, unsigned short th);
    unsigned short atan2(short y, short x);

    void copy(const unsigned char *src, int count);
    void copyram(unsigned char *src, int count);

    void self_calibrate(void);

    void swap(void);
    void flush(void);
    void finish(void);

    void play(unsigned char instrument, unsigned char note = 0);
    void sample(unsigned int start, unsigned int len, unsigned short freq, unsigned short format, int loop = 0);

    void get_inputs(void);
    void get_accel(int &x, int &y, int &z);
    struct {
        unsigned short track_tag;
        unsigned short track_val;
        unsigned short rz;
        unsigned short __dummy_1;
        short y;
        short x;
        short tag_y;
        short tag_x;
        unsigned char tag;
        unsigned char ptag;
    } inputs;

    void AlphaFunc(unsigned char func, unsigned char ref);
    void Begin(unsigned char prim);
    void BitmapHandle(unsigned char handle);
    void BitmapLayout(unsigned char format, unsigned short linestride, unsigned short height);
    void BitmapSize(unsigned char filter, unsigned char wrapx, unsigned char wrapy, unsigned short width, unsigned short height);
    void BitmapSource(unsigned int addr);
    void BitmapTransformA(int a);
    void BitmapTransformB(int b);
    void BitmapTransformC(int c);
    void BitmapTransformD(int d);
    void BitmapTransformE(int e);
    void BitmapTransformF(int f);
    void BlendFunc(unsigned char src, unsigned char dst);
    void Call(unsigned short dest);
    void Cell(unsigned char cell);
    void ClearColorA(unsigned char alpha);
    void ClearColorRGB(unsigned char red, unsigned char green, unsigned char blue);
    void ClearColorRGB(unsigned int rgb);
    void Clear(unsigned char c, unsigned char s, unsigned char t);
    void Clear(void);
    void ClearStencil(unsigned char s);
    void ClearTag(unsigned char s);
    void ColorA(unsigned char alpha);
    void ColorMask(unsigned char r, unsigned char g, unsigned char b, unsigned char a);
    void ColorRGB(unsigned char red, unsigned char green, unsigned char blue);
    void ColorRGB(unsigned int rgb);
    void Display(void);
    void End(void);
    void Jump(unsigned short dest);
    void LineWidth(unsigned short width);
    void Macro(unsigned char m);
    void PointSize(unsigned short size);
    void RestoreContext(void);
    void Return(void);
    void SaveContext(void);
    void ScissorSize(unsigned short width, unsigned short height);
    void ScissorXY(unsigned short x, unsigned short y);
    void StencilFunc(unsigned char func, unsigned char ref, unsigned char mask);
    void StencilMask(unsigned char mask);
    void StencilOp(unsigned char sfail, unsigned char spass);
    void TagMask(unsigned char mask);
    void Tag(unsigned char s);
    void Vertex2f(short x, short y);
    void Vertex2ii(unsigned short x, unsigned short y, unsigned char handle = 0, unsigned char cell = 0);

    // Higher-level graphics commands

    void cmd_append(unsigned int ptr, unsigned int num);
    void cmd_bgcolor(unsigned int c);
    void cmd_button(short x, short y, unsigned short w, unsigned short h, unsigned char font, unsigned short options, const char *s);
    void cmd_calibrate(void);
    void cmd_clock(short x, short y, short r, unsigned short options, unsigned short h, unsigned short m, unsigned short s, unsigned short ms);
    void cmd_coldstart(void);
    void cmd_dial(short x, short y, short r, unsigned short options, unsigned short val);
    void cmd_dlstart(void);
    void cmd_fgcolor(unsigned int c);
    void cmd_gauge(short x, short y, short r, unsigned short options, unsigned short major, unsigned short minor, unsigned short val, unsigned short range);
    void cmd_getmatrix(void);
    void cmd_getprops(unsigned int &ptr, unsigned int &w, unsigned int &h);
    void cmd_getptr(void);
    void cmd_gradcolor(unsigned int c);
    void cmd_gradient(short x0, short y0, unsigned int rgb0, short x1, short y1, unsigned int rgb1);
    void cmd_inflate(unsigned int ptr);
    void cmd_interrupt(unsigned int ms);
    void cmd_keys(short x, short y, short w, short h, unsigned char font, unsigned short options, const char*s);
    void cmd_loadidentity(void);
    void cmd_loadimage(unsigned int ptr, int options);
    void cmd_memcpy(unsigned int dest, unsigned int src, unsigned int num);
    void cmd_memset(unsigned int ptr, unsigned char value, unsigned int num);
    unsigned int cmd_memcrc(unsigned int ptr, unsigned int num);
    void cmd_memwrite(unsigned int ptr, unsigned int num);
    void cmd_regwrite(unsigned int ptr, unsigned int val);
    void cmd_number(short x, short y, unsigned char font, unsigned short options, unsigned int n);
    void cmd_progress(short x, short y, short w, short h, unsigned short options, unsigned short val, unsigned short range);
    void cmd_regread(unsigned int ptr);
    void cmd_rotate(int a);
    void cmd_scale(int sx, int sy);
    void cmd_screensaver(void);
    void cmd_scrollbar(short x, short y, short w, short h, unsigned short options, unsigned short val, unsigned short size, unsigned short range);
    void cmd_setfont(unsigned char font, unsigned int ptr);
    void cmd_setmatrix(void);
    void cmd_sketch(short x, short y, unsigned short w, unsigned short h, unsigned int ptr, unsigned short format);
    void cmd_slider(short x, short y, unsigned short w, unsigned short h, unsigned short options, unsigned short val, unsigned short range);
    void cmd_snapshot(unsigned int ptr);
    void cmd_spinner(short x, short y, unsigned char style, unsigned char scale);
    void cmd_stop(void);
    void cmd_swap(void);
    void cmd_text(short x, short y, unsigned char font, unsigned short options, const char *s);
    void cmd_toggle(short x, short y, short w, unsigned char font, unsigned short options, unsigned short state, const char *s);
    void cmd_track(short x, short y, unsigned short w, unsigned short h, unsigned char tag);
    void cmd_translate(int tx, int ty);

    unsigned char rd(unsigned int addr);
    void wr(unsigned int addr, unsigned char v);
    unsigned short rd16(unsigned int addr);
    void wr16(unsigned int addr, unsigned short v);
    unsigned int rd32(unsigned int addr);
    void wr32(unsigned int addr, unsigned int v);
    void wr_n(unsigned int addr, unsigned char *src, unsigned int n);

    void cmd32(unsigned int b);

    void bulkrd(unsigned int a);
    void resume(void);
    void __end(void);
    void reset(void);

    void dumpscreen(void);
    unsigned char load(const char *filename, void (*progress)(long, long) = NULL);
    void safeload(const char *filename);

    void storage(void);
    void tune(void);

private:
    void cFFFFFF(unsigned char v);
    void cI(unsigned int);
    void ci(int);
    void cH(unsigned short);
    void ch(short);
    void cs(const char *);
    void fmtcmd(const char *fmt, ...);

    void align(unsigned char n);
    void cmdbyte(unsigned char b);

    unsigned int measure_freq(void);

    unsigned short lfsr, lcg;
};
#endif
