#include "mbed.h"
#include "LinearCharacteristics.h"
#include "ControllerLoop.h"
static BufferedSerial serial_port(USBTX, USBRX);
DigitalOut led(LED1);
// The controller Thread
float Ts = 0.2;
LinearCharacteristics gyro(0,1,-400,400);

ControllerLoop loop(Ts);                        // this is forthe main controller loop
//******************************************************************************
//---------- main loop -------------
//******************************************************************************
int main()
{
    serial_port.set_baud(115200);
    serial_port.set_format(
        /* bits */ 8,
        /* parity */ BufferedSerial::None,
        /* stop bit */ 1
    );
    printf("gyro ( 0.2) = %f\r\n",gyro(0.2));
    serial_port.set_blocking(false); // force to send whenever possible and data is there
    loop.start_loop();
  
    while(1)
        { 
        ThisThread::sleep_for(1000);
        }
}   // END OF main
