/*
   PRBS: pseudo random binary sequence generator

    instantiate option: PRBS(int n)
    
    hints: - the output delivers a new excitation signal with the values -1 or 1.
           - after 2^n-1 samples the sequenz repeats infinite

        n:  create a sequence of length 2^n-1
            n = 2...19 is supported

        autor: M.E. Peter
*/

#include "PRBS.h"
#include "mbed.h"
#include "math.h"

using namespace std;

PRBS::PRBS(int n)
{
    this->n = n;
    Nprbs = (int)pow((float)2, (float)n) - 1;
    getPrbsIndex(n);
    reset();
}

PRBS::~PRBS() {}

void PRBS::reset()
{
    ii = 1;
    //default register
    int initRegister[19] = {1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1};
    Register = (int*)malloc(n*sizeof(int));
    for(int i = 0; i < n; i++) {
        Register[i] = initRegister[i];
    }
}

float PRBS::update()
{
    int prbs = Register[n-1];
    int x = (Register[ind[0]-1] + Register[ind[1]-1])%2;
    for(int i = 1; i < Nind-1; i++) {
        x = (x + Register[ind[i+1]-1])%2;
    }
    for(int i = n-1; i > 0; i--) {
        Register[i] = Register[i-1];
    }
    Register[0] = x;
    // printf("%4i : %4i %4i %4i %4i %4i %4i %4i %4i , %4.4f \r\n", ii, Register[0], Register[1], Register[2], Register[3], Register[4], Register[5], Register[6], Register[7], 2.0f*((float)prbs - 0.5f));
    if(ii++ == Nprbs) reset();
    return 2.0f*((float)prbs - 0.5f);
}

void PRBS::getPrbsIndex(int n)
{
    switch (n) {
        case 2:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 1;
            ind[1] = n;
            break;
        case 3:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 1;
            ind[1] = n;
            break;
        case 4:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 1;
            ind[1] = n;
            break;
        case 5:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 2;
            ind[1] = n;
            break;
        case 6:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 1;
            ind[1] = n;
            break;
        case 7:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 1;
            ind[1] = n;
            break;
        case 8:
            Nind = 4;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 1;
            ind[1] = 2;
            ind[2] = 7;
            ind[3] = n;
            break;
        case 9:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 4;
            ind[1] = n;
            break;
        case 10:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 3;
            ind[1] = n;
            break;
        case 11:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 2;
            ind[1] = n;
            break;
        case 12:
            Nind = 4;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 4;
            ind[1] = 10;
            ind[2] = 11;
            ind[3] = n;
            break;
        case 13:
            Nind = 4;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 8;
            ind[1] = 11;
            ind[2] = 12;
            ind[3] = n;
            break;
        case 14:
            Nind = 4;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 2;
            ind[1] = 12;
            ind[2] = 13;
            ind[3] = n;
            break;
        case 15:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 14;
            ind[1] = n;
            break;
        case 16:
            Nind = 4;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 11;
            ind[1] = 13;
            ind[2] = 14;
            ind[3] = n;
            break;
        case 17:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 14;
            ind[1] = n;
            break;
        case 18:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 11;
            ind[1] = n;
            break;
        case 19:
            Nind = 4;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 14;
            ind[1] = 17;
            ind[2] = 18;
            ind[3] = n;
            break;
        default:
            Nind = 2;
            ind = (int*)malloc(Nind*sizeof(int));
            ind[0] = 0;
            ind[1] = 0;
            break;
    }
}

void PRBS::printLine()
{
    printf("-----------------------------------------------------------------------------------------\r\n");
}

void PRBS::printPRBSind()
{
    printLine();
    for(int i = 0; i < Nind; i++) {
        printf("%6i \r\n", ind[i]);
    }
}

void PRBS::printPRBSregister()
{
    printLine();
    for(int i = 0; i < n; i++) {
        printf("%6i \r\n", Register[i]);
    }
}
