#ifndef PIDT2_CNTRL_H_
#define PIDT2_CNTRL_H_

#include "mbed.h"

class PIDT2_Cntrl
{
public:

    PIDT2_Cntrl(float P, float I, float D, float tau_f, float tau_ro, float Ts, float uMin, float uMax);

    PIDT2_Cntrl() {};

    float operator()(float e)
    {
        return update(e);
    }
    float operator()(float e, float y)
    {
        return update(e, y);
    }

    virtual ~PIDT2_Cntrl();

    void    reset(float initValue);
    void    setCoefficients(float P, float I, float D, float tau_f, float tau_ro, float Ts, float uMin, float uMax);
    void    setCoeff_P(float P);
    void    setCoeff_I(float D);
    void    setCoeff_D(float D);
    void    scale_PIDT2_param(float scale);
    float   update(float e);
    float   update(float e, float y);
    void    set_limits(float uMin, float uMax);
    float   get_ulimit();
    float   get_P_gain();
		float   get_I();
		float   get_D();
    float   get_bd();
    float   get_ad();
		float   get_bi();
		float   get_bf();
		float   get_af();
		

private:
		
    float   IPart, Dpart, d_old, u_old, uf;
    float  	P, I, D, tau_f, tau_ro, Ts, uMin, uMax;
    float  	bi, bd, ad, bf, af;
    float  	P_init, I_init, D_init;

    void    setCoefficients(float P, float I, float D, float tau_f, float tau_ro, float Ts);
    float   saturate(float u, float uMin, float uMax);

};

#endif
