#include "PolynomialCharacteristics.h"
#include "math.h"
using namespace std;
PolynomialCharacteristics::PolynomialCharacteristics(float *P,uint8_t degree,float ll, float ul){    // standard lin characteristics
    this->P = (float*)malloc(degree*sizeof(float));
    for(int k=0;k<=degree;k++)
        this->P[k] =P[k];
    this->degree = degree;
    this->llim = ll;
    this->ulim = ul;
    
}

PolynomialCharacteristics::~PolynomialCharacteristics() {}


float PolynomialCharacteristics::evaluate(float x)
{   
float dum = 0.0;
for(int k=0;k<=degree;k++)
    dum = P[k]*pow(x,(float)k);
if(dum > this->ulim)
    dum = this->ulim;
if(dum < this->llim)
    dum = this->llim;
return dum;
    }
