#include "LinearCharacteristics.h"
#include "mbed.h"
#include "define_constants.h"

class RCin {
public:

RCin(PinName pin);
void fall_edge(void);
void rise_edge(void);
uint8_t get_flightmode(void);
bool flightmode_changed;

float PM1[15];
LinearCharacteristics CH1_2_PM1;
LinearCharacteristics CH2_2_PM1;
LinearCharacteristics CH3_2_PM1;
LinearCharacteristics CH4_2_PM1;

void map_Channels(void);
uint16_t pwms[255];
uint16_t test_pwms[200][12];
uint16_t cou;
bool isAlive;
    
private:
    PinName pin;
    InterruptIn pwm1;
    Timer local_ti;
    uint8_t chnr;
    uint8_t old_flightmode;
    void map_pwm_2_PM1(void);
    uint8_t current_flightmode;
};
