class PI_Cntrl
{
public:

    PI_Cntrl(float Kp, float Tn, float Ts);
    PI_Cntrl(float Kp, float Tn, float Ts, float uMax);
    PI_Cntrl(float Kp, float Tn, float Ts, float uMax, float uMin);

    float operator()(float error) {
        return doStep((double)error);
    }

    virtual     ~PI_Cntrl();

    void        reset(float initValue);
    float       doStep(double error);

private:

    double b0;
    double b1;
    double b2;
    double s;
    double uMax;
    double uMin;
    
    void        setCoefficients(float Kp, float Tn, float Ts);

};