class GPAf
{
public:

    GPAf(float fMin, float fMax, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1);
    GPAf(float f0, float f1, float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1);
    GPAf(float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1);

    float operator()(float inp, float out) {
        return update((float)inp, (float)out);
    }

    virtual ~GPAf();

    void     reset();
    float    update(float inp, float out);

    void     printGPAfexcDes();
    void     printGPAmeasPara();
    void     printGPAmeasTime();
    void     printNfexcDes();

private:

    int     NfexcDes;
    int     NperMin;
    int     NmeasMin;
    float  Ts;
    float *fexcDes;
    float  aAexcDes;
    float  bAexcDes;

    float  fnyq;
    float  pi2;
    float  pi2Ts;
    float  piDiv2;

    int     Nmeas;
    int     Nper;
    float  fexc;
    float  fexcPast;
    int     ii;
    int     jj;
    float  scaleG;
    float  scaleH;
    float  wk;
    float  cr;
    float  ci;
    float *sU;
    float *sY;
    float  sinarg;
    int     NmeasTotal;
    float  Aexc;
    float  pi2Tsfexc;

    void    fexcDesLogspace(float fMin, float fMax, int NfexcDes);
    void    calcGPAmeasPara(float fexcDes_i);
    void    printLine();
    void    calcHann();

};