class GPA
{
public:

    GPA(float fMin, float fMax, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1);
    GPA(float f0, float f1, float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1);
    GPA(float *fexcDes, int NfexcDes, int NperMin, int NmeasMin, float Ts, float Aexc0, float Aexc1);

    float operator()(float inp, float out) {
        return update((double)inp, (double)out);
    }

    virtual ~GPA();

    void     reset();
    float    update(double inp, double out);

    void     printGPAfexcDes();
    void     printGPAmeasPara();
    void     printGPAmeasTime();
    void     printNfexcDes();

private:

    int     NfexcDes;
    int     NperMin;
    int     NmeasMin;
    double  Ts;
    double *fexcDes;
    double  aAexcDes;
    double  bAexcDes;

    double  fnyq;
    double  pi2;
    double  pi2Ts;
    double  piDiv2;

    int     Nmeas;
    int     Nper;
    double  fexc;
    double  fexcPast;
    int     ii;
    int     jj;
    double  scaleG;
    double  scaleH;
    double  wk;
    double  cr;
    double  ci;
    double *sU;
    double *sY;
    double  sinarg;
    int     NmeasTotal;
    double  Aexc;
    double  pi2Tsfexc;

    void    fexcDesLogspace(double fMin, double fMax, int NfexcDes);
    void    calcGPAmeasPara(double fexcDes_i);
    void    printLine();
    void    calcHann();

};