#include "Mahony.h"
#include "MadgwickAHRS.h"
#include "LinearCharacteristics.h"
#include "LSM9DS1.h"
#include "Signal.h"

class AHRS{
public:
    AHRS(uint8_t,float);
    virtual ~AHRS();
    
    float getRollRadians() {
        if (!RPY_filter.anglesComputed) RPY_filter.computeAngles();
        return RPY_filter.getRoll();
    }
    float getPitchRadians() {
        if (!RPY_filter.anglesComputed) RPY_filter.computeAngles();
        return RPY_filter.getPitch();
    }
    float getYawRadians() {
        if (!RPY_filter.anglesComputed) RPY_filter.computeAngles();
        return RPY_filter.getYaw();
    }
    LSM9DS1 imu;
    Mahony RPY_filter;
    LinearCharacteristics raw_gx2gx;
    LinearCharacteristics raw_gy2gy;
    LinearCharacteristics raw_gz2gz;
private:
    Signal signal;
    Thread thread;
    Ticker ticker;
    Mutex mutex;      // mutex to lock critical sections 
    void sendSignal();
    void update();
    LinearCharacteristics raw_ax2ax;
    LinearCharacteristics raw_ay2ay;
    LinearCharacteristics raw_az2az;
    LinearCharacteristics int2magx;     
    LinearCharacteristics int2magy;
    LinearCharacteristics int2magz;
    SPI spi;
    DigitalOut csAG;         // for spi
    DigitalOut csM;           //  "
};
