#include "AHRS.h"
#include "Mahony.h"
#include "MadgwickAHRS.h"
#define PI 3.141592653589793

using namespace std;

AHRS::AHRS(uint8_t filtertype,float TS) : RPY_filter(TS), csAG(PA_15),csM(PD_2), spi(PC_12, PC_11, PC_10), imu(&spi, &csM, &csAG), thread(osPriorityBelowNormal, 4096){  
    
    thread.start(callback(this, &AHRS::update));
    ticker.attach(callback(this, &AHRS::sendSignal), TS);
    LinearCharacteristics raw_ax2ax(40.0/65536.0,-418.0);       // use gain and offset here
    LinearCharacteristics raw_ay2ay(-40.0/65536.0,-307.0);      // y-axis reversed
    LinearCharacteristics raw_az2az(-16350.0,16350,-10.0, 10.0);
    LinearCharacteristics raw_gx2gx(-32767,32768,-500*PI/180.0, 500*PI/180.0);
    LinearCharacteristics raw_gy2gy(-32767,32768, 500*PI/180.0,-500*PI/180.0);  // y-axis reversed (lefthanded system)
    LinearCharacteristics raw_gz2gz(-32767,32768,-500*PI/180.0, 500*PI/180.0);
    LinearCharacteristics int2magx( -32767,32768,100.0,-100.0);     // x-axis reversed
    LinearCharacteristics int2magy( -32767,32768,100.0,-100.0);     // y-axis reversed
    LinearCharacteristics int2magz( -32767,32768,-100.0,100.0);
    while (!imu.begin()) {
        wait(1);
        printf("Failed to communicate with LSM9DS1.\r\n");
    }

}

AHRS::~AHRS() {}

void AHRS::update(void)
{
    while(1){
        thread.signal_wait(signal);
        imu.readAccel();
        imu.readMag_calibrated();
        imu.readGyro();

        //Perform Madgwick-filter update
        RPY_filter.update(raw_gx2gx(imu.gx), raw_gy2gy(imu.gy),  raw_gz2gz(imu.gz) ,
                      raw_ax2ax(imu.ax), raw_ay2ay(imu.ay),  raw_az2az(imu.az),
                      int2magx(imu.mx), int2magy(imu.my),  int2magz(imu.mz)); 
       
 
        }       // while(1)
}
void AHRS::sendSignal() {
    
    thread.signal_set(signal);
}