/*
    The MIT License (MIT)
    
    Copyright (c) 2015 Tom Soulanille
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    @file          snet.cpp
    @purpose       simple networking
    @version       0.1
    @date          31 March 2015
    @author        Tom Soulanille    
*/

#include "snet.h"

#if 0
// if not otherwise available, use this to print memory in hex
void print_hex(const uint8_t *p, int len) {
    while (len > 0) {
        for (int i=0; i<16 && len-->0; i++) {
            printf(" 0x%02x", *p++);
        }
        printf("\r\n");
    }
}
#endif

const uint8_t Snet::broadcast_mac[] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
const uint8_t Snet::ipEtherType[] = { 0x08, 0x00 };
const uint8_t Snet::arp_req_payload_prefix[] = { 0x0, 0x1, 0x8, 0x0, 0x6, 0x4, 0x0, 0x1 };

Snet::Snet(): eth()
{
    eth.address((char *) my_mac);
    printf("MAC %02x:%02x:%02x:%02x:%02x:%02x\r\n",
        my_mac[0], my_mac[1], my_mac[2], my_mac[3], my_mac[4], my_mac[5]);
    printf("no IP\r\n");
}

Snet::Snet(const uint8_t *ip): eth()
{
    eth.address((char *) my_mac);
    printf("MAC %02x:%02x:%02x:%02x:%02x:%02x\r\n",
        my_mac[0], my_mac[1], my_mac[2], my_mac[3], my_mac[4], my_mac[5]);
    memcpy(my_ip, ip, 4);
    printf("IP %d.%d.%d.%d\r\n",
        my_ip[0], my_ip[1], my_ip[2], my_ip[3]);
}

void Snet::handle_arp_request(uint8_t *buf, int len) {
#if 0
    printf("Arp from %02x:%02x:%02x:%02x:%02x:%02x\r\n",
            buf[ENET_SMAC_O+0], buf[ENET_SMAC_O+1],
            buf[ENET_SMAC_O+2], buf[ENET_SMAC_O+3],
            buf[ENET_SMAC_O+4], buf[ENET_SMAC_O+5]);
#endif
    eth.read((char *) &buf[ENET_PAYLOAD_O], len-ENET_PAYLOAD_O);
    /*print_hex((uint8_t *) &buf[ENET_PAYLOAD_O], len-ENET_PAYLOAD_O);*/
    if (!(memcmp(&buf[ENET_PAYLOAD_O], arp_req_payload_prefix, sizeof(arp_req_payload_prefix)) // ARP request
            || memcmp(&buf[ENET_ARP_TPA_O], my_ip, sizeof(my_ip)))) {  // for me
        //ARP request for me. Build reply.
        // Ethernet packet addresses:
        memcpy(&buf[ENET_DMAC_O], &buf[ENET_SMAC_O], 6);    // Back to sender
        memcpy(&buf[ENET_SMAC_O], my_mac, 6);   // from me
        // ARP protocol packet:
        buf[ENET_ARP_OPER_O+1] = 0x02;  // we are replying
        memcpy(&buf[ENET_ARP_THA_O], &buf[ENET_ARP_SHA_O], 6);  // to hardware address of request sender
        memcpy(&buf[ENET_ARP_TPA_O], &buf[ENET_ARP_SPA_O], 4);  // to IP address of request sender
        memcpy(&buf[ENET_ARP_SHA_O], my_mac, 6);  // from my hardware address
        memcpy(&buf[ENET_ARP_SPA_O], my_ip, 4);  // and my IP address
#if 0
        printf("ARP replying\r\n");
        print_hex((uint8_t *) buf, len);
#endif
        eth.write((char *) buf, len);
        eth.send();
    };
};

void Snet::got_broadcast(uint8_t *buf, int len) {
#if 0
    printf("Broadcast from: %02x:%02x:%02x:%02x:%02x:%02x type %02x%02x count %d\r\n",
            buf[ENET_SMAC_O+0], buf[ENET_SMAC_O+1],
            buf[ENET_SMAC_O+2], buf[ENET_SMAC_O+3],
            buf[ENET_SMAC_O+4], buf[ENET_SMAC_O+5],
            buf[ENET_ETHERTYPE_O+0], buf[ENET_ETHERTYPE_O+1],
            enet_rx_int_cnt);
#endif
};

void Snet::got_unicast(uint8_t *buf, int len) {
    if (memcmp(&buf[ENET_ETHERTYPE_O], ipEtherType, 2)) return;
    // IP packets only from this point
//    printf("Unicast from: %02x:%02x:%02x:%02x:%02x:%02x %d\r\n",
//            buf[6], buf[7], buf[8], buf[9], buf[10], buf[11], enet_rx_int_cnt);
    memcpy(correspondent_mac, &buf[ENET_SMAC_O], sizeof(correspondent_mac));
    eth.read((char *) &buf[ENET_PAYLOAD_O], len-ENET_PAYLOAD_O); // Read in the whole rest of the packet
    interpret_inet_packet(buf, len);
}

int Snet::rx_and_process_available_packets() {
#if 0
    // if the MBED Ethernet worked correctly:
    uint8_t buf[0x600];
#else
    uint8_t buf[750+6+6+2];   // Experimentally-derived maximum packet size is 750 at the IP layer
#endif
    int rv = 0;
    int len;
    
    while ((len = eth.receive()) > 0) {
        eth.read((char *) buf, ENET_PAYLOAD_O);  // destination MAC, source MAC, EtherType, lengcode
        enet_rx_cnt++;
        // ARP request?
        if (buf[ENET_ETHERTYPE_O+0] == 0x08 && buf[ENET_ETHERTYPE_O+1] == 0x06)
            handle_arp_request(buf, len);
        else if (memcmp(&buf[ENET_DMAC_O], my_mac, 6) == 0) {
            got_unicast(buf, len);
        } else if (memcmp(&buf[ENET_DMAC_O], broadcast_mac, 6) == 0) {
            got_broadcast(buf, len);
        }
        rv++;
    }
    return rv;
}

