/*
 * Copyright (c) 2013 Tom Soulanille
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SCOPE_RAM_H
#define SCOPE_RAM_H
#include "rtos.h"

#define WATERMARK 0xaa

class RAMscope {

  public:
    RAMscope(PinName trigger_pin, PinName value_pin);
    void watermark(unsigned char *start, int length);
    void scope(unsigned char *start, int length=128, int period=10);
    void stop();
    
  private:
    DigitalOut trigger_output, value_output;
    RtosTimer scope_ram_timer;
    static void scope_ram(const void *arg);
    void output_to_scope(void);
    unsigned char *start;
    int length;
};

#endif