/*
 * Copyright (c) 2013 Tom Soulanille
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "scope_RAM.h"

RAMscope::RAMscope(
    PinName trigger_pin,
    PinName value_pin
) :
    trigger_output(trigger_pin),
    value_output(value_pin),
    scope_ram_timer(&RAMscope::scope_ram, osTimerPeriodic, (void *)this)
{
    
}

void RAMscope::scope_ram(const void *arg) {
    RAMscope *instance = (RAMscope*)arg;
    instance->output_to_scope();
}

void RAMscope::output_to_scope(void) {
    int i;
    unsigned char *p = start;
    trigger_output = true; trigger_output = false;
    for (i=0; i<length; i++) {
        value_output = *p++ == WATERMARK;
    }
    value_output = false;
}

void RAMscope::watermark(unsigned char *st, int len) {
    while (len--) *st++ = WATERMARK;
}

void RAMscope::scope(unsigned char *st, int len, int period) {
    start = st;
    length = len;
    scope_ram_timer.start(period);
}

void RAMscope::stop() {
    scope_ram_timer.stop();
}
